var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

import { GL, Buffer, TransformFeedback } from 'luma.gl';
import AttributeTransitionModel from './attribute-transition-model';
import log from '../utils/log';
import assert from 'assert';

var TRANSITION_STATE = {
  NONE: 0,
  PENDING: 1,
  STARTED: 2,
  ENDED: 3
};

var noop = function noop() {};

var AttributeTransitionManager = function () {
  function AttributeTransitionManager(gl, _ref) {
    var id = _ref.id;

    _classCallCheck(this, AttributeTransitionManager);

    this.id = id;
    this.gl = gl;

    this.isSupported = TransformFeedback.isSupported(gl);

    this.attributeTransitions = {};
    this.needsRedraw = false;
    this.model = null;

    if (this.isSupported) {
      this.transformFeedback = new TransformFeedback(gl);
    } else {
      log.warn(0, 'WebGL2 not supported by this browser. Transition animation is disabled.');
    }
  }

  /* Public methods */

  // Called when attribute manager updates
  // Check the latest attributes for updates.


  _createClass(AttributeTransitionManager, [{
    key: 'update',
    value: function update(attributes) {
      var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

      this.opts = opts;

      if (!this.isSupported) {
        return;
      }

      var needsNewModel = false;
      var attributeTransitions = this.attributeTransitions;

      var changedTransitions = {};

      for (var attributeName in attributes) {
        var transition = this._updateAttribute(attributeName, attributes[attributeName]);

        if (transition) {
          if (!attributeTransitions[attributeName]) {
            // New animated attribute is added
            attributeTransitions[attributeName] = transition;
            needsNewModel = true;
          }
          changedTransitions[attributeName] = transition;
        }
      }

      for (var _attributeName in attributeTransitions) {
        var attribute = attributes[_attributeName];

        if (!attribute || !attribute.transition) {
          // Animated attribute has been removed
          delete attributeTransitions[_attributeName];
          needsNewModel = true;
        }
      }

      if (needsNewModel) {
        this._createModel();
      } else if (this.model) {
        this.model.setTransitions(changedTransitions);
      }
    }

    // Returns `true` if attribute is transition-enabled

  }, {
    key: 'hasAttribute',
    value: function hasAttribute(attributeName) {
      return attributeName in this.attributeTransitions;
    }

    // Get all the animated attributes

  }, {
    key: 'getAttributes',
    value: function getAttributes() {
      var animatedAttributes = {};

      for (var attributeName in this.attributeTransitions) {
        var transition = this.attributeTransitions[attributeName];

        if (transition.buffer) {
          animatedAttributes[attributeName] = transition.buffer;
        }
      }

      return animatedAttributes;
    }

    /* eslint-disable max-statements */
    // Called every render cycle, run transform feedback
    // Returns `true` if anything changes

  }, {
    key: 'setCurrentTime',
    value: function setCurrentTime(currentTime) {
      if (!this.model) {
        return false;
      }

      var uniforms = {};
      var buffers = {};

      var needsRedraw = this.needsRedraw;
      this.needsRedraw = false;

      for (var attributeName in this.attributeTransitions) {
        var transition = this.attributeTransitions[attributeName];

        buffers[transition.bufferIndex] = transition.buffer;

        var time = 1;
        if (transition.state === TRANSITION_STATE.PENDING) {
          transition.startTime = currentTime;
          transition.state = TRANSITION_STATE.STARTED;
          transition.onStart(transition);
        }

        if (transition.state === TRANSITION_STATE.STARTED) {
          time = (currentTime - transition.startTime) / transition.duration;
          if (time >= 1) {
            time = 1;
            transition.state = TRANSITION_STATE.ENDED;
            transition.onEnd(transition);
          }
          needsRedraw = true;
        }

        uniforms[transition.name + 'Time'] = transition.easing(time);
      }

      if (needsRedraw) {
        this._runTransformFeedback({ uniforms: uniforms, buffers: buffers });
      }

      return needsRedraw;
    }
    /* eslint-enable max-statements */

    /* Private methods */

    // Check an attributes for updates
    // Returns a transition object if a new transition is triggered.

  }, {
    key: '_updateAttribute',
    value: function _updateAttribute(attributeName, attribute) {
      var settings = this._getTransitionSettings(attribute);

      if (settings) {
        var hasChanged = void 0;
        var transition = this.attributeTransitions[attributeName];
        if (transition) {
          hasChanged = attribute.changed;
        } else {
          // New animated attributes have been added
          transition = { name: attributeName, attribute: attribute };
          hasChanged = true;
        }

        if (hasChanged) {
          this._triggerTransition(transition, settings);
          return transition;
        }
      }

      return null;
    }

    // Redraw the transform feedback

  }, {
    key: '_runTransformFeedback',
    value: function _runTransformFeedback(_ref2) {
      var uniforms = _ref2.uniforms,
          buffers = _ref2.buffers;
      var model = this.model,
          transformFeedback = this.transformFeedback;


      transformFeedback.bindBuffers(buffers, {});

      model.draw({
        uniforms: uniforms,
        transformFeedback: transformFeedback,
        parameters: _defineProperty({}, GL.RASTERIZER_DISCARD, true)
      });
    }

    // Create a model for the transform feedback

  }, {
    key: '_createModel',
    value: function _createModel() {
      if (this.model) {
        this.model.destroy();
      }

      this.model = new AttributeTransitionModel(this.gl, {
        id: this.id,
        transitions: this.attributeTransitions
      });
    }

    // get current values of an attribute, clipped/padded to the size of the new buffer

  }, {
    key: '_getCurrentAttributeState',
    value: function _getCurrentAttributeState(transition) {
      var attribute = transition.attribute,
          buffer = transition.buffer;
      var value = attribute.value,
          type = attribute.type,
          size = attribute.size;


      if (buffer) {
        // If new buffer is bigger than old buffer, back fill with destination values
        var oldBufferData = new Float32Array(value);
        buffer.getData({ dstData: oldBufferData });
        // Hack/Xiaoji: WebGL2 throws error if TransformFeedback does not render to
        // a buffer of type Float32Array.
        // Therefore we need to read data as a Float32Array then re-cast to attribute type
        if (!(value instanceof Float32Array)) {
          oldBufferData = new value.constructor(oldBufferData);
        }
        return { size: size, type: type, value: oldBufferData };
      }
      return { size: size, type: type, value: value };
    }

    // Returns transition settings object if transition is enabled, otherwise `null`

  }, {
    key: '_getTransitionSettings',
    value: function _getTransitionSettings(attribute) {
      var opts = this.opts;
      var transition = attribute.transition,
          accessor = attribute.accessor;


      if (!transition) {
        return null;
      }

      return Array.isArray(accessor) ? accessor.map(function (a) {
        return opts[a];
      }).find(Boolean) : opts[accessor];
    }

    // Normalizes transition settings object, merge with default settings

  }, {
    key: '_normalizeTransitionSettings',
    value: function _normalizeTransitionSettings(settings) {
      // Shorthand: use duration instead of parameter object
      if (Number.isFinite(settings)) {
        settings = { duration: settings };
      }

      // Check if settings is valid
      assert(settings && settings.duration > 0);

      return {
        duration: settings.duration,
        easing: settings.easing || function (t) {
          return t;
        },
        onStart: settings.onStart || noop,
        onEnd: settings.onEnd || noop,
        onInterrupt: settings.onInterrupt || noop
      };
    }

    // Start a new transition using the current settings
    // Updates transition state and from/to buffer

  }, {
    key: '_triggerTransition',
    value: function _triggerTransition(transition, settings) {
      this.needsRedraw = true;

      var attribute = transition.attribute,
          buffer = transition.buffer;
      var value = attribute.value,
          size = attribute.size;


      var transitionSettings = this._normalizeTransitionSettings(settings);

      var needsNewBuffer = !buffer || transition.bufferSize < value.length;

      // Attribute descriptor to transition from
      // _getCurrentAttributeState must be called before the current buffer is deleted
      var fromState = this._getCurrentAttributeState(transition);

      // Attribute descriptor to transition to
      // Pre-converting to buffer to reuse in the case where no transition is needed
      var toState = new Buffer(this.gl, { size: size, data: value });

      if (needsNewBuffer) {
        if (buffer) {
          buffer.delete();
        }

        transition.buffer = new Buffer(this.gl, {
          size: size,
          instanced: attribute.instanced,
          // WebGL2 throws error if `value` is not cast to Float32Array:
          // `transformfeedback buffers : buffer or buffer range not large enough`
          data: new Float32Array(value.length),
          usage: GL.DYNAMIC_COPY
        });
        transition.bufferSize = value.length;
      }

      Object.assign(transition, transitionSettings);
      transition.fromState = fromState;
      transition.toState = toState;

      // Reset transition state
      if (transition.state === TRANSITION_STATE.STARTED) {
        transition.onInterrupt(transition);
      }
      transition.state = TRANSITION_STATE.PENDING;
    }
  }]);

  return AttributeTransitionManager;
}();

export default AttributeTransitionManager;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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