var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.
import Layer from './layer';
import log from '../utils/log';
import { flatten } from '../utils/flatten';

var CompositeLayer = function (_Layer) {
  _inherits(CompositeLayer, _Layer);

  function CompositeLayer(props) {
    _classCallCheck(this, CompositeLayer);

    return _possibleConstructorReturn(this, (CompositeLayer.__proto__ || Object.getPrototypeOf(CompositeLayer)).call(this, props));
  }

  _createClass(CompositeLayer, [{
    key: 'getSubLayers',
    value: function getSubLayers() {
      return this.internalState.subLayers || [];
    }

    // initializeState is usually not needed for composite layers
    // Provide empty definition to disable check for missing definition

  }, {
    key: 'initializeState',
    value: function initializeState() {}

    // called to augment the info object that is bubbled up from a sublayer
    // override Layer.getPickingInfo() because decoding / setting uniform do
    // not apply to a composite layer.
    // @return null to cancel event

  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref) {
      var info = _ref.info;

      return info;
    }

    // Implement to generate subLayers

  }, {
    key: 'renderLayers',
    value: function renderLayers() {
      return null;
    }

    // Returns sub layer props for a specific sublayer

  }, {
    key: 'getSubLayerProps',
    value: function getSubLayerProps(sublayerProps) {
      var _props = this.props,
          opacity = _props.opacity,
          pickable = _props.pickable,
          visible = _props.visible,
          parameters = _props.parameters,
          getPolygonOffset = _props.getPolygonOffset,
          highlightedObjectIndex = _props.highlightedObjectIndex,
          autoHighlight = _props.autoHighlight,
          highlightColor = _props.highlightColor,
          coordinateSystem = _props.coordinateSystem,
          coordinateOrigin = _props.coordinateOrigin,
          modelMatrix = _props.modelMatrix;

      var newProps = {
        opacity: opacity,
        pickable: pickable,
        visible: visible,
        parameters: parameters,
        getPolygonOffset: getPolygonOffset,
        highlightedObjectIndex: highlightedObjectIndex,
        autoHighlight: autoHighlight,
        highlightColor: highlightColor,
        coordinateSystem: coordinateSystem,
        coordinateOrigin: coordinateOrigin,
        modelMatrix: modelMatrix
      };

      if (sublayerProps) {
        Object.assign(newProps, sublayerProps, {
          id: this.props.id + '-' + sublayerProps.id,
          updateTriggers: Object.assign({
            all: this.props.updateTriggers.all
          }, sublayerProps.updateTriggers)
        });
      }

      return newProps;
    }

    // Called by layer manager to render subLayers

  }, {
    key: '_renderLayers',
    value: function _renderLayers() {
      var subLayers = this.internalState.subLayers;

      if (subLayers && !this.needsUpdate()) {
        log.log(3, 'Composite layer reused subLayers ' + this, this.internalState.subLayers);
      } else {
        subLayers = this.renderLayers();
        // Flatten the returned array, removing any null, undefined or false
        // this allows layers to render sublayers conditionally
        // (see CompositeLayer.renderLayers docs)
        subLayers = flatten(subLayers, { filter: Boolean });
        this.internalState.subLayers = subLayers;
        log.log(2, 'Composite layer rendered new subLayers ' + this, subLayers);
      }

      // populate reference to parent layer (this layer)
      // NOTE: needs to be done even when reusing layers as the parent may have changed
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = subLayers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var layer = _step.value;

          layer.parentLayer = this;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'isComposite',
    get: function get() {
      return true;
    }
  }]);

  return CompositeLayer;
}(Layer);

export default CompositeLayer;


CompositeLayer.layerName = 'CompositeLayer';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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