// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { global } from '../utils/globals';
import log from '../utils/log';
// Version detection using babel plugin
// Fallback for tests and SSR since global variable is defined by Webpack.
/* global __VERSION__ */
var version = typeof '5.1.4' !== 'undefined' ? '5.1.4' : global.DECK_VERSION || 'untranspiled source';

var STARTUP_MESSAGE = 'set deck.log.priority=1 (or higher) to trace attribute updates';

if (global.deck && global.deck.VERSION !== version) {
  throw new Error('deck.gl - multiple versions detected: ' + global.deck.VERSION + ' vs ' + version);
}

if (!global.deck) {
  /* global console */
  /* eslint-disable no-console */
  console.log('deck.gl ' + version + ' - ' + STARTUP_MESSAGE);

  global.deck = global.deck || {
    VERSION: version,
    version: version,
    log: log
  };
}

// TODO - Hack, remove when luma.gl 4.1.0-alpha.5 is published
if (!console.table) {
  console.table = function () {};
}

// Make sure we register shader modules
require('../shaderlib');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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