var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/* global window */
import { COORDINATE_SYSTEM, LIFECYCLE } from './constants';
import AttributeManager from './attribute-manager';
import Stats from './stats';
import { count } from '../utils/count';
import log from '../utils/log';
import { createProps } from '../lifecycle/create-props';
import { diffProps as _diffProps } from '../lifecycle/props';
import { removeLayerInSeer } from './seer-integration';
import { GL, withParameters } from 'luma.gl';
import assert from 'assert';

var LOG_PRIORITY_UPDATE = 1;
var EMPTY_PROPS = Object.freeze({});
var noop = function noop() {};

var defaultProps = {
  // data: Special handling for null, see below
  dataComparator: null,
  updateTriggers: {}, // Update triggers: a core change detection mechanism in deck.gl
  numInstances: undefined,

  visible: true,
  pickable: false,
  opacity: 0.8,

  onHover: noop,
  onClick: noop,

  coordinateSystem: COORDINATE_SYSTEM.LNGLAT,
  coordinateOrigin: [0, 0, 0],

  parameters: {},
  uniforms: {},
  framebuffer: null,

  animation: null, // Passed prop animation functions to evaluate props

  // Offset depth based on layer index to avoid z-fighting.
  // Negative values pull layer towards the camera
  // https://www.opengl.org/archives/resources/faq/technical/polygonoffset.htm
  getPolygonOffset: function getPolygonOffset(_ref) {
    var layerIndex = _ref.layerIndex;
    return [0, -layerIndex * 100];
  },

  // Selection/Highlighting
  highlightedObjectIndex: null,
  autoHighlight: false,
  highlightColor: [0, 0, 128, 128]
};

var counter = 0;

var Layer = function () {
  // constructor(...propObjects)
  function Layer() {
    _classCallCheck(this, Layer);

    // Merges incoming props with defaults and freezes them.
    // TODO switch to spread operator once we no longer transpile this code
    // this.props = createProps.apply(propObjects);
    /* eslint-disable prefer-spread */
    this.props = createProps.apply(this, arguments);
    /* eslint-enable prefer-spread */

    // Define all members before layer is sealed
    this.id = this.props.id; // The layer's id, used for matching with layers from last render cycle
    this.oldProps = EMPTY_PROPS; // Props from last render used for change detection
    this.count = counter++; // Keep track of how many layer instances you are generating
    this.lifecycle = LIFECYCLE.NO_STATE; // Helps track and debug the life cycle of the layers
    this.state = null; // Will be set to the shared layer state object during layer matching
    this.context = null; // Will reference layer manager's context, contains state shared by layers
    this.parentLayer = null; // reference to the composite layer parent that rendered this layer

    // CompositeLayer members, need to be defined here because of the `Object.seal`
    this.internalState = null;

    // Seal the layer
    Object.seal(this);
  }

  // clone this layer with modified props


  _createClass(Layer, [{
    key: 'clone',
    value: function clone(newProps) {
      return new this.constructor(Object.assign({}, this.props, newProps));
    }
  }, {
    key: 'toString',
    value: function toString() {
      var className = this.constructor.layerName || this.constructor.name;
      return className + '({id: \'' + this.props.id + '\'})';
    }
  }, {
    key: 'setState',


    // Public API

    // Updates selected state members and marks the object for redraw
    value: function setState(updateObject) {
      Object.assign(this.state, updateObject);
      this.state.needsRedraw = true;
    }

    // Sets the redraw flag for this layer, will trigger a redraw next animation frame

  }, {
    key: 'setNeedsRedraw',
    value: function setNeedsRedraw() {
      var redraw = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;

      if (this.state) {
        this.state.needsRedraw = redraw;
      }
    }

    // Checks state of attributes and model

  }, {
    key: 'getNeedsRedraw',
    value: function getNeedsRedraw() {
      var _ref2 = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
          _ref2$clearRedrawFlag = _ref2.clearRedrawFlags,
          clearRedrawFlags = _ref2$clearRedrawFlag === undefined ? false : _ref2$clearRedrawFlag;

      return this._getNeedsRedraw(clearRedrawFlags);
    }

    // Return an array of models used by this layer, can be overriden by layer subclass

  }, {
    key: 'getModels',
    value: function getModels() {
      return this.state.models || (this.state.model ? [this.state.model] : []);
    }
  }, {
    key: 'needsUpdate',
    value: function needsUpdate() {
      // Call subclass lifecycle method
      return this.shouldUpdateState(this._getUpdateParams());
      // End lifecycle method
    }

    // Returns true if the layer is pickable and visible.

  }, {
    key: 'isPickable',
    value: function isPickable() {
      return this.props.pickable && this.props.visible;
    }
  }, {
    key: 'getAttributeManager',
    value: function getAttributeManager() {
      return this.state && this.state.attributeManager;
    }

    // Use iteration (the only required capability on data) to get first element
    // deprecated

  }, {
    key: 'getFirstObject',
    value: function getFirstObject() {
      var data = this.props.data;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          return object;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }

      return null;
    }

    // PROJECTION METHODS

    /**
     * Projects a point with current map state (lat, lon, zoom, pitch, bearing)
     *
     * Note: Position conversion is done in shader, so in many cases there is no need
     * for this function
     * @param {Array|TypedArray} lngLat - long and lat values
     * @return {Array|TypedArray} - x, y coordinates
     */

  }, {
    key: 'project',
    value: function project(lngLat) {
      var viewport = this.context.viewport;

      assert(Array.isArray(lngLat), 'Layer.project needs [lng,lat]');
      return viewport.project(lngLat);
    }
  }, {
    key: 'unproject',
    value: function unproject(xy) {
      var viewport = this.context.viewport;

      assert(Array.isArray(xy), 'Layer.unproject needs [x,y]');
      return viewport.unproject(xy);
    }
  }, {
    key: 'projectFlat',
    value: function projectFlat(lngLat) {
      var viewport = this.context.viewport;

      assert(Array.isArray(lngLat), 'Layer.project needs [lng,lat]');
      return viewport.projectFlat(lngLat);
    }
  }, {
    key: 'unprojectFlat',
    value: function unprojectFlat(xy) {
      var viewport = this.context.viewport;

      assert(Array.isArray(xy), 'Layer.unproject needs [x,y]');
      return viewport.unprojectFlat(xy);
    }

    // TODO - needs to refer to context

  }, {
    key: 'screenToDevicePixels',
    value: function screenToDevicePixels(screenPixels) {
      log.deprecated('screenToDevicePixels', 'DeckGL prop useDevicePixels for conversion');
      var devicePixelRatio = typeof window !== 'undefined' ? window.devicePixelRatio : 1;
      return screenPixels * devicePixelRatio;
    }

    /**
     * Returns the picking color that doesn't match any subfeature
     * Use if some graphics do not belong to any pickable subfeature
     * @return {Array} - a black color
     */

  }, {
    key: 'nullPickingColor',
    value: function nullPickingColor() {
      return [0, 0, 0];
    }

    /**
     * Returns the picking color that doesn't match any subfeature
     * Use if some graphics do not belong to any pickable subfeature
     * @param {int} i - index to be decoded
     * @return {Array} - the decoded color
     */

  }, {
    key: 'encodePickingColor',
    value: function encodePickingColor(i) {
      assert((i + 1 >> 24 & 255) === 0, 'index out of picking color range');
      return [i + 1 & 255, i + 1 >> 8 & 255, i + 1 >> 8 >> 8 & 255];
    }

    /**
     * Returns the picking color that doesn't match any subfeature
     * Use if some graphics do not belong to any pickable subfeature
     * @param {Uint8Array} color - color array to be decoded
     * @return {Array} - the decoded picking color
     */

  }, {
    key: 'decodePickingColor',
    value: function decodePickingColor(color) {
      assert(color instanceof Uint8Array);

      var _color = _slicedToArray(color, 3),
          i1 = _color[0],
          i2 = _color[1],
          i3 = _color[2];
      // 1 was added to seperate from no selection


      var index = i1 + i2 * 256 + i3 * 65536 - 1;
      return index;
    }

    // //////////////////////////////////////////////////
    // LIFECYCLE METHODS, overridden by the layer subclasses

    // Called once to set up the initial state
    // App can create WebGL resources

  }, {
    key: 'initializeState',
    value: function initializeState() {
      throw new Error('Layer ' + this + ' has not defined initializeState');
    }

    // Let's layer control if updateState should be called

  }, {
    key: 'shouldUpdateState',
    value: function shouldUpdateState(_ref3) {
      var oldProps = _ref3.oldProps,
          props = _ref3.props,
          oldContext = _ref3.oldContext,
          context = _ref3.context,
          changeFlags = _ref3.changeFlags;

      return changeFlags.propsOrDataChanged;
    }

    // Default implementation, all attributes will be invalidated and updated
    // when data changes

  }, {
    key: 'updateState',
    value: function updateState(_ref4) {
      var oldProps = _ref4.oldProps,
          props = _ref4.props,
          oldContext = _ref4.oldContext,
          context = _ref4.context,
          changeFlags = _ref4.changeFlags;

      var attributeManager = this.getAttributeManager();
      if (changeFlags.dataChanged && attributeManager) {
        attributeManager.invalidateAll();
      }
    }

    // Called once when layer is no longer matched and state will be discarded
    // App can destroy WebGL resources here

  }, {
    key: 'finalizeState',
    value: function finalizeState() {
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = this.getModels()[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var model = _step2.value;

          model.delete();
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }

    // Update attribute transition

  }, {
    key: 'updateTransition',
    value: function updateTransition() {
      var _state = this.state,
          model = _state.model,
          attributeManager = _state.attributeManager;

      var isInTransition = attributeManager && attributeManager.updateTransition();

      if (model && isInTransition) {
        model.setAttributes(attributeManager.getChangedAttributes({ transition: true }));
      }
    }

    // If state has a model, draw it with supplied uniforms

  }, {
    key: 'draw',
    value: function draw(opts) {
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = this.getModels()[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var model = _step3.value;

          model.draw(opts);
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }

    // called to populate the info object that is passed to the event handler
    // @return null to cancel event

  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref5) {
      var info = _ref5.info,
          mode = _ref5.mode;
      var index = info.index;


      if (index >= 0) {
        // If props.data is an indexable array, get the object
        if (Array.isArray(this.props.data)) {
          info.object = this.props.data[index];
        }
      }

      return info;
    }

    // END LIFECYCLE METHODS
    // //////////////////////////////////////////////////

    // Default implementation of attribute invalidation, can be redefined

  }, {
    key: 'invalidateAttribute',
    value: function invalidateAttribute() {
      var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'all';
      var diffReason = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';

      var attributeManager = this.getAttributeManager();
      if (!attributeManager) {
        return;
      }

      if (name === 'all') {
        log.log(LOG_PRIORITY_UPDATE, 'updateTriggers invalidating all attributes: ' + diffReason);
        attributeManager.invalidateAll();
      } else {
        log.log(LOG_PRIORITY_UPDATE, 'updateTriggers invalidating attribute ' + name + ': ' + diffReason);
        attributeManager.invalidate(name);
      }
    }

    // Calls attribute manager to update any WebGL attributes, can be redefined

  }, {
    key: 'updateAttributes',
    value: function updateAttributes(props) {
      var attributeManager = this.getAttributeManager();
      if (!attributeManager) {
        return;
      }

      // Figure out data length
      var numInstances = this.getNumInstances(props);

      attributeManager.update({
        data: props.data,
        numInstances: numInstances,
        props: props,
        transitions: props.transitions,
        buffers: props,
        context: this,
        // Don't worry about non-attribute props
        ignoreUnknownAttributes: true
      });

      // TODO - Use getModels?
      var model = this.state.model;

      if (model) {
        var changedAttributes = attributeManager.getChangedAttributes({ clearChangedFlags: true });
        model.setAttributes(changedAttributes);
      }
    }
  }, {
    key: 'calculateInstancePickingColors',
    value: function calculateInstancePickingColors(attribute, _ref6) {
      var numInstances = _ref6.numInstances;
      var value = attribute.value,
          size = attribute.size;
      // add 1 to index to seperate from no selection

      for (var i = 0; i < numInstances; i++) {
        var pickingColor = this.encodePickingColor(i);
        value[i * size + 0] = pickingColor[0];
        value[i * size + 1] = pickingColor[1];
        value[i * size + 2] = pickingColor[2];
      }
    }

    // INTERNAL METHODS

    // Deduces numer of instances. Intention is to support:
    // - Explicit setting of numInstances
    // - Auto-deduction for ES6 containers that define a size member
    // - Auto-deduction for Classic Arrays via the built-in length attribute
    // - Auto-deduction via arrays

  }, {
    key: 'getNumInstances',
    value: function getNumInstances(props) {
      props = props || this.props;

      // First check if the layer has set its own value
      if (this.state && this.state.numInstances !== undefined) {
        return this.state.numInstances;
      }

      // Check if app has provided an explicit value
      if (props.numInstances !== undefined) {
        return props.numInstances;
      }

      // Use container library to get a count for any ES6 container or object
      var _props = props,
          data = _props.data;

      return count(data);
    }

    // LAYER MANAGER API
    // Should only be called by the deck.gl LayerManager class

    // Called by layer manager when a new layer is found
    /* eslint-disable max-statements */

  }, {
    key: '_initialize',
    value: function _initialize() {
      assert(arguments.length === 0);
      assert(this.context.gl);
      assert(!this.state);

      var attributeManager = new AttributeManager(this.context.gl, {
        id: this.props.id
      });

      // All instanced layers get instancePickingColors attribute by default
      // Their shaders can use it to render a picking scene
      // TODO - this slightly slows down non instanced layers
      attributeManager.addInstanced({
        instancePickingColors: {
          type: GL.UNSIGNED_BYTE,
          size: 3,
          update: this.calculateInstancePickingColors
        }
      });

      this.internalState = {
        subLayers: null, // reference to sublayers rendered in a previous cycle
        stats: new Stats({ id: 'draw' })
        // animatedProps: null, // Computing animated props requires layer manager state
        // TODO - move these fields here (risks breaking layers)
        // attributeManager,
        // needsRedraw: true,
      };

      this.state = {
        attributeManager: attributeManager,
        model: null,
        needsRedraw: true
      };

      // Call subclass lifecycle methods
      this.initializeState(this.context);
      // End subclass lifecycle methods

      // initializeState callback tends to clear state
      this.setChangeFlags({ dataChanged: true, propsChanged: true, viewportChanged: true });

      this._updateState(this._getUpdateParams());

      if (this.isComposite) {
        this._renderLayers(true);
      }

      var model = this.state.model;

      if (model) {
        model.id = this.props.id;
        model.program.id = this.props.id + '-program';
        model.geometry.id = this.props.id + '-geometry';
        model.setAttributes(attributeManager.getAttributes());
      }

      // Last but not least, update any sublayers
      if (this.isComposite) {
        this._renderLayers();
      }

      this.clearChangeFlags();
    }

    // Called by layer manager
    // if this layer is new (not matched with an existing layer) oldProps will be empty object

  }, {
    key: '_update',
    value: function _update() {
      assert(arguments.length === 0);

      // Call subclass lifecycle method
      var stateNeedsUpdate = this.needsUpdate();
      // End lifecycle method

      var updateParams = this._getUpdateParams();

      if (stateNeedsUpdate) {
        this._updateState(updateParams);
      }

      // Render or update previously rendered sublayers
      if (this.isComposite) {
        this._renderLayers(stateNeedsUpdate);
      }

      this.clearChangeFlags();
      // Release old props for GC once update is complete
      this.oldProps = EMPTY_PROPS;
    }
    /* eslint-enable max-statements */

  }, {
    key: '_updateState',
    value: function _updateState(updateParams) {
      // Call subclass lifecycle methods
      this.updateState(updateParams);
      // End subclass lifecycle methods

      // Add any subclass attributes
      this.updateAttributes(this.props);
      this._updateBaseUniforms();
      this._updateModuleSettings();

      // Note: Automatic instance count update only works for single layers
      if (this.state.model) {
        this.state.model.setInstanceCount(this.getNumInstances());
      }
    }

    // Called by manager when layer is about to be disposed
    // Note: not guaranteed to be called on application shutdown

  }, {
    key: '_finalize',
    value: function _finalize() {
      assert(arguments.length === 0);
      // Call subclass lifecycle method
      this.finalizeState(this.context);
      // End lifecycle method
      removeLayerInSeer(this.id);
    }

    // Calculates uniforms

  }, {
    key: 'drawLayer',
    value: function drawLayer(_ref7) {
      var _this = this;

      var _ref7$moduleParameter = _ref7.moduleParameters,
          moduleParameters = _ref7$moduleParameter === undefined ? null : _ref7$moduleParameter,
          _ref7$uniforms = _ref7.uniforms,
          uniforms = _ref7$uniforms === undefined ? {} : _ref7$uniforms,
          _ref7$parameters = _ref7.parameters,
          parameters = _ref7$parameters === undefined ? {} : _ref7$parameters;

      if (!uniforms.picking_uActive) {
        this.updateTransition();
      }

      // TODO/ib - hack move to luma Model.draw
      if (moduleParameters) {
        var _iteratorNormalCompletion4 = true;
        var _didIteratorError4 = false;
        var _iteratorError4 = undefined;

        try {
          for (var _iterator4 = this.getModels()[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
            var model = _step4.value;

            model.updateModuleSettings(moduleParameters);
          }
        } catch (err) {
          _didIteratorError4 = true;
          _iteratorError4 = err;
        } finally {
          try {
            if (!_iteratorNormalCompletion4 && _iterator4.return) {
              _iterator4.return();
            }
          } finally {
            if (_didIteratorError4) {
              throw _iteratorError4;
            }
          }
        }
      }

      // Apply polygon offset to avoid z-fighting
      // TODO - move to draw-layers
      var getPolygonOffset = this.props.getPolygonOffset;

      var offsets = getPolygonOffset && getPolygonOffset(uniforms) || [0, 0];
      parameters.polygonOffset = offsets;

      // Call subclass lifecycle method
      withParameters(this.context.gl, parameters, function () {
        _this.draw({ moduleParameters: moduleParameters, uniforms: uniforms, parameters: parameters, context: _this.context });
      });
      // End lifecycle method
    }

    // {uniforms = {}, ...opts}

  }, {
    key: 'pickLayer',
    value: function pickLayer(opts) {
      // Call subclass lifecycle method
      return this.getPickingInfo(opts);
      // End lifecycle method
    }

    // Helper methods

  }, {
    key: 'getChangeFlags',
    value: function getChangeFlags() {
      return this.internalState.changeFlags;
    }

    // Dirty some change flags, will be handled by updateLayer
    /* eslint-disable complexity */

  }, {
    key: 'setChangeFlags',
    value: function setChangeFlags(flags) {
      var _this2 = this;

      this.internalState.changeFlags = this.internalState.changeFlags || {};
      var changeFlags = this.internalState.changeFlags;

      // Update primary flags
      if (flags.dataChanged && !changeFlags.dataChanged) {
        changeFlags.dataChanged = flags.dataChanged;
        log.log(LOG_PRIORITY_UPDATE + 1, function () {
          return 'dataChanged: ' + flags.dataChanged + ' in ' + _this2.id;
        });
      }
      if (flags.updateTriggersChanged && !changeFlags.updateTriggersChanged) {
        changeFlags.updateTriggersChanged = changeFlags.updateTriggersChanged && flags.updateTriggersChanged ? Object.assign({}, flags.updateTriggersChanged, changeFlags.updateTriggersChanged) : flags.updateTriggersChanged || changeFlags.updateTriggersChanged;
        log.log(LOG_PRIORITY_UPDATE + 1, function () {
          return 'updateTriggersChanged: ' + (Object.keys(flags.updateTriggersChanged).join(', ') + ' in ' + _this2.id);
        });
      }
      if (flags.propsChanged && !changeFlags.propsChanged) {
        changeFlags.propsChanged = flags.propsChanged;
        log.log(LOG_PRIORITY_UPDATE + 1, function () {
          return 'propsChanged: ' + flags.propsChanged + ' in ' + _this2.id;
        });
      }
      if (flags.viewportChanged && !changeFlags.viewportChanged) {
        changeFlags.viewportChanged = flags.viewportChanged;
        log.log(LOG_PRIORITY_UPDATE + 2, function () {
          return 'viewportChanged: ' + flags.viewportChanged + ' in ' + _this2.id;
        });
      }

      // Update composite flags
      var propsOrDataChanged = flags.dataChanged || flags.updateTriggersChanged || flags.propsChanged;
      changeFlags.propsOrDataChanged = changeFlags.propsOrDataChanged || propsOrDataChanged;
      changeFlags.somethingChanged = changeFlags.somethingChanged || propsOrDataChanged || flags.viewportChanged;
    }
    /* eslint-enable complexity */

    // Clear all changeFlags, typically after an update

  }, {
    key: 'clearChangeFlags',
    value: function clearChangeFlags() {
      this.internalState.changeFlags = {
        // Primary changeFlags, can be strings stating reason for change
        dataChanged: false,
        propsChanged: false,
        updateTriggersChanged: false,
        viewportChanged: false,

        // Derived changeFlags
        propsOrDataChanged: false,
        somethingChanged: false
      };
    }
  }, {
    key: 'printChangeFlags',
    value: function printChangeFlags() {
      var flags = this.internalState.changeFlags;
      return '' + (flags.dataChanged ? 'data ' : '') + (flags.propsChanged ? 'props ' : '') + (flags.updateTriggersChanged ? 'triggers ' : '') + (flags.viewportChanged ? 'viewport' : '');
    }

    // Compares the layers props with old props from a matched older layer
    // and extracts change flags that describe what has change so that state
    // can be update correctly with minimal effort
    // TODO - arguments for testing only

  }, {
    key: 'diffProps',
    value: function diffProps() {
      var newProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.props;
      var oldProps = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.oldProps;

      var changeFlags = _diffProps(newProps, oldProps);

      // iterate over changedTriggers
      if (changeFlags.updateTriggersChanged) {
        for (var key in changeFlags.updateTriggersChanged) {
          if (changeFlags.updateTriggersChanged[key]) {
            this._activeUpdateTrigger(key);
          }
        }
      }

      return this.setChangeFlags(changeFlags);
    }

    // PRIVATE METHODS

  }, {
    key: '_getUpdateParams',
    value: function _getUpdateParams() {
      return {
        props: this.props,
        oldProps: this.oldProps,
        context: this.context,
        oldContext: this.oldContext || {},
        changeFlags: this.internalState.changeFlags
      };
    }

    // Checks state of attributes and model

  }, {
    key: '_getNeedsRedraw',
    value: function _getNeedsRedraw(clearRedrawFlags) {
      // this method may be called by the render loop as soon a the layer
      // has been created, so guard against uninitialized state
      if (!this.state) {
        return false;
      }

      var redraw = false;
      redraw = redraw || this.state.needsRedraw && this.id;
      this.state.needsRedraw = this.state.needsRedraw && !clearRedrawFlags;

      // TODO - is attribute manager needed? - Model should be enough.
      var attributeManager = this.getAttributeManager();
      var attributeManagerNeedsRedraw = attributeManager && attributeManager.getNeedsRedraw({ clearRedrawFlags: clearRedrawFlags });
      redraw = redraw || attributeManagerNeedsRedraw;

      var _iteratorNormalCompletion5 = true;
      var _didIteratorError5 = false;
      var _iteratorError5 = undefined;

      try {
        for (var _iterator5 = this.getModels()[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
          var model = _step5.value;

          var modelNeedsRedraw = model.getNeedsRedraw({ clearRedrawFlags: clearRedrawFlags });
          if (modelNeedsRedraw && typeof modelNeedsRedraw !== 'string') {
            modelNeedsRedraw = 'model ' + model.id;
          }
          redraw = redraw || modelNeedsRedraw;
        }
      } catch (err) {
        _didIteratorError5 = true;
        _iteratorError5 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion5 && _iterator5.return) {
            _iterator5.return();
          }
        } finally {
          if (_didIteratorError5) {
            throw _iteratorError5;
          }
        }
      }

      return redraw;
    }

    // Called by layer manager to transfer state from an old layer

  }, {
    key: '_transferState',
    value: function _transferState(oldLayer) {
      var state = oldLayer.state,
          internalState = oldLayer.internalState,
          props = oldLayer.props;

      assert(state && internalState);

      // Move state
      state.layer = this;
      this.state = state;
      this.internalState = internalState;
      // Note: We keep the state ref on old layers to support async actions
      // oldLayer.state = null;

      // Keep a temporary ref to the old props, for prop comparison
      this.oldProps = props;

      // Update model layer reference
      var _iteratorNormalCompletion6 = true;
      var _didIteratorError6 = false;
      var _iteratorError6 = undefined;

      try {
        for (var _iterator6 = this.getModels()[Symbol.iterator](), _step6; !(_iteratorNormalCompletion6 = (_step6 = _iterator6.next()).done); _iteratorNormalCompletion6 = true) {
          var model = _step6.value;

          model.userData.layer = this;
        }
      } catch (err) {
        _didIteratorError6 = true;
        _iteratorError6 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion6 && _iterator6.return) {
            _iterator6.return();
          }
        } finally {
          if (_didIteratorError6) {
            throw _iteratorError6;
          }
        }
      }

      this.diffProps();
    }

    // Operate on each changed triggers, will be called when an updateTrigger changes

  }, {
    key: '_activeUpdateTrigger',
    value: function _activeUpdateTrigger(propName) {
      this.invalidateAttribute(propName);
    }

    //  Helper to check that required props are supplied

  }, {
    key: '_checkRequiredProp',
    value: function _checkRequiredProp(propertyName, condition) {
      var value = this.props[propertyName];
      if (value === undefined) {
        throw new Error('Property ' + propertyName + ' undefined in layer ' + this);
      }
      if (condition && !condition(value)) {
        throw new Error('Bad property ' + propertyName + ' in layer ' + this);
      }
    }
  }, {
    key: '_updateBaseUniforms',
    value: function _updateBaseUniforms() {
      var uniforms = {
        // apply gamma to opacity to make it visually "linear"
        opacity: Math.pow(this.props.opacity, 1 / 2.2),
        ONE: 1.0
      };
      var _iteratorNormalCompletion7 = true;
      var _didIteratorError7 = false;
      var _iteratorError7 = undefined;

      try {
        for (var _iterator7 = this.getModels()[Symbol.iterator](), _step7; !(_iteratorNormalCompletion7 = (_step7 = _iterator7.next()).done); _iteratorNormalCompletion7 = true) {
          var model = _step7.value;

          model.setUniforms(uniforms);
        }

        // TODO - set needsRedraw on the model(s)?
      } catch (err) {
        _didIteratorError7 = true;
        _iteratorError7 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion7 && _iterator7.return) {
            _iterator7.return();
          }
        } finally {
          if (_didIteratorError7) {
            throw _iteratorError7;
          }
        }
      }

      this.state.needsRedraw = true;
    }
  }, {
    key: '_updateModuleSettings',
    value: function _updateModuleSettings() {
      var settings = {
        pickingHighlightColor: this.props.highlightColor
      };
      var _iteratorNormalCompletion8 = true;
      var _didIteratorError8 = false;
      var _iteratorError8 = undefined;

      try {
        for (var _iterator8 = this.getModels()[Symbol.iterator](), _step8; !(_iteratorNormalCompletion8 = (_step8 = _iterator8.next()).done); _iteratorNormalCompletion8 = true) {
          var model = _step8.value;

          model.updateModuleSettings(settings);
        }
      } catch (err) {
        _didIteratorError8 = true;
        _iteratorError8 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion8 && _iterator8.return) {
            _iterator8.return();
          }
        } finally {
          if (_didIteratorError8) {
            throw _iteratorError8;
          }
        }
      }
    }

    // DEPRECATED METHODS

    // Updates selected state members and marks the object for redraw

  }, {
    key: 'setUniforms',
    value: function setUniforms(uniformMap) {
      var _iteratorNormalCompletion9 = true;
      var _didIteratorError9 = false;
      var _iteratorError9 = undefined;

      try {
        for (var _iterator9 = this.getModels()[Symbol.iterator](), _step9; !(_iteratorNormalCompletion9 = (_step9 = _iterator9.next()).done); _iteratorNormalCompletion9 = true) {
          var model = _step9.value;

          model.setUniforms(uniformMap);
        }

        // TODO - set needsRedraw on the model(s)?
      } catch (err) {
        _didIteratorError9 = true;
        _iteratorError9 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion9 && _iterator9.return) {
            _iterator9.return();
          }
        } finally {
          if (_didIteratorError9) {
            throw _iteratorError9;
          }
        }
      }

      this.state.needsRedraw = true;
      log.deprecated('layer.setUniforms', 'model.setUniforms');
    }
  }, {
    key: 'stats',
    get: function get() {
      return this.internalState.stats;
    }
  }]);

  return Layer;
}();

export default Layer;


Layer.layerName = 'Layer';
Layer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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