var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Stats = function () {
  function Stats(_ref) {
    var id = _ref.id;

    _classCallCheck(this, Stats);

    this.id = id;
    this.time = 0;
    this.total = 0;
    this.average = 0;
    this.count = 0;

    this._time = 0;
  }

  _createClass(Stats, [{
    key: 'timeStart',
    value: function timeStart() {
      this._time = this.timestampMs();
    }
  }, {
    key: 'timeEnd',
    value: function timeEnd() {
      this.time = this.timestampMs() - this._time;
      this.total += this.time;
      this.count++;
      this.average = this.total / this.count;
    }
  }, {
    key: 'timestampMs',
    value: function timestampMs() {
      /* global window */
      return typeof window !== 'undefined' && window.performance ? window.performance.now() : Date.now();
    }
  }, {
    key: 'getTimeString',
    value: function getTimeString() {
      return this.id + ':' + formatTime(this.time) + '(' + this.count + ')';
    }
  }]);

  return Stats;
}();

// TODO: Currently unused, keeping in case we want it later for log formatting


export default Stats;
export function formatTime(ms) {
  var formatted = void 0;
  if (ms < 10) {
    formatted = ms.toFixed(2) + 'ms';
  } else if (ms < 100) {
    formatted = ms.toFixed(1) + 'ms';
  } else if (ms < 1000) {
    formatted = ms.toFixed(0) + 'ms';
  } else {
    formatted = (ms / 1000).toFixed(2) + 's';
  }
  return formatted;
}

export function leftPad(string) {
  var length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 8;

  while (string.length < length) {
    string = ' ' + string;
  }
  return string;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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