// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// lighting

export default "#define NUM_OF_LIGHTS 2\n\n// TODO these should be using lighting_ prefix\nuniform vec3 lightsPosition[16];\nuniform vec2 lightsStrength[16];\nuniform float ambientRatio;\nuniform float diffuseRatio;\nuniform float specularRatio;\n\nfloat lighting_getLightWeight(vec3 position_worldspace_vec3, vec3 normals_worldspace) {\n  float lightWeight = 0.0;\n\n  vec3 normals_worldspace_vec3 = normals_worldspace.xyz;\n\n  vec3 camera_pos_worldspace = project_uCameraPosition;\n  vec3 view_direction = normalize(camera_pos_worldspace - position_worldspace_vec3);\n\n  for (int i = 0; i < NUM_OF_LIGHTS; i++) {\n    vec3 light_position_worldspace = project_position(lightsPosition[i]);\n    vec3 light_direction = normalize(light_position_worldspace - position_worldspace_vec3);\n\n    vec3 halfway_direction = normalize(light_direction + view_direction);\n    float lambertian = dot(light_direction, normals_worldspace_vec3);\n    float specular = 0.0;\n    if (lambertian > 0.0) {\n      float specular_angle = max(dot(normals_worldspace_vec3, halfway_direction), 0.0);\n      specular = pow(specular_angle, 32.0);\n    }\n    lambertian = max(lambertian, 0.0);\n    lightWeight += (ambientRatio + lambertian * diffuseRatio + specular * specularRatio) *\n      lightsStrength[i].x;\n\n  }\n\n  return lightWeight;\n}\n\n// DEPRECATED - Backwards compatibility\n\nfloat getLightWeight(vec3 position_worldspace_vec3, vec3 normals_worldspace) {\n  return lighting_getLightWeight(position_worldspace_vec3, normals_worldspace);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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