import { mod } from '../utils/math-utils';

var VIEWPORT_PROPS = ['width', 'height', 'longitude', 'latitude', 'zoom', 'bearing', 'pitch', 'position'];

var WRAPPED_ANGULAR_PROPS = {
  longitude: 1,
  bearing: 1
};

export function lerp(start, end, step) {
  if (Array.isArray(start)) {
    return start.map(function (element, index) {
      return lerp(element, end[index], step);
    });
  }
  return step * end + (1 - step) * start;
}

export function isValid(prop) {
  return Number.isFinite(prop) || Array.isArray(prop);
}

function isWrappedAngularProp(propName) {
  return WRAPPED_ANGULAR_PROPS[propName];
}

export function getEndValueByShortestPath(propName, startValue, endValue) {
  if (isWrappedAngularProp(propName) && Math.abs(endValue - startValue) > 180) {
    endValue = endValue < 0 ? endValue + 360 : endValue - 360;
  }
  return endValue;
}

// TODO/xiaoji: This should be merged with the controller's prop constraint system
export function extractViewportFrom(props) {
  var viewport = {};
  VIEWPORT_PROPS.forEach(function (key) {
    var value = props[key];
    if (isValid(value)) {
      viewport[key] = value;
      // Normalize longitude and bearing into [-180, 180) range
      // This gurantees the props are in same range when they are interpolated.
      if (isWrappedAngularProp(key)) {
        viewport[key] = mod(value + 180, 360) - 180;
      }
    }
  });
  return viewport;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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