var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/* eslint-disable no-console */
/* global console */
import assert from 'assert';

var cache = {};

function log(priority, arg) {
  for (var _len = arguments.length, args = Array(_len > 2 ? _len - 2 : 0), _key = 2; _key < _len; _key++) {
    args[_key - 2] = arguments[_key];
  }

  assert(Number.isFinite(priority), 'log priority must be a number');
  if (priority <= log.priority) {
    // Node doesn't have console.debug, but using it looks better in browser consoles
    args = formatArgs.apply(undefined, [arg].concat(_toConsumableArray(args)));
    if (console.debug) {
      var _console;

      (_console = console).debug.apply(_console, _toConsumableArray(args));
    } else {
      var _console2;

      (_console2 = console).info.apply(_console2, _toConsumableArray(args));
    }
  }
}

function once(priority, arg) {
  for (var _len2 = arguments.length, args = Array(_len2 > 2 ? _len2 - 2 : 0), _key2 = 2; _key2 < _len2; _key2++) {
    args[_key2 - 2] = arguments[_key2];
  }

  if (!cache[arg] && priority <= log.priority) {
    var _console3;

    args = checkForAssertionErrors(args);
    (_console3 = console).error.apply(_console3, _toConsumableArray(formatArgs.apply(undefined, [arg].concat(_toConsumableArray(args)))));
    cache[arg] = true;
  }
}

function warn(arg) {
  if (!cache[arg]) {
    var _console4;

    for (var _len3 = arguments.length, args = Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {
      args[_key3 - 1] = arguments[_key3];
    }

    (_console4 = console).warn.apply(_console4, ['deck.gl: ' + arg].concat(args));
    cache[arg] = true;
  }
}

function error(arg) {
  var _console5;

  for (var _len4 = arguments.length, args = Array(_len4 > 1 ? _len4 - 1 : 0), _key4 = 1; _key4 < _len4; _key4++) {
    args[_key4 - 1] = arguments[_key4];
  }

  (_console5 = console).error.apply(_console5, ['deck.gl: ' + arg].concat(args));
}

function deprecated(oldUsage, newUsage) {
  log.warn('`' + oldUsage + '` is deprecated and will be removed in a later version. Use `' + newUsage + '` instead');
}

function removed(oldUsage, newUsage) {
  log.error('`' + oldUsage + '` is no longer supported. Use `' + newUsage + '` instead, check our upgrade-guide.md for more details');
}

// Logs a message with a time
function time(priority, label) {
  assert(Number.isFinite(priority), 'log priority must be a number');
  if (priority <= log.priority) {
    // In case the platform doesn't have console.time
    if (console.time) {
      console.time(label);
    } else {
      console.info(label);
    }
  }
}

function timeEnd(priority, label) {
  assert(Number.isFinite(priority), 'log priority must be a number');
  if (priority <= log.priority) {
    // In case the platform doesn't have console.timeEnd
    if (console.timeEnd) {
      console.timeEnd(label);
    } else {
      console.info(label);
    }
  }
}

function group(priority, arg) {
  var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      _ref$collapsed = _ref.collapsed,
      collapsed = _ref$collapsed === undefined ? false : _ref$collapsed;

  if (priority <= log.priority) {
    if (collapsed) {
      console.groupCollapsed('luma.gl: ' + arg);
    } else {
      console.group('luma.gl: ' + arg);
    }
  }
}

function groupEnd(priority, arg) {
  if (priority <= log.priority) {
    console.groupEnd('luma.gl: ' + arg);
  }
}

// Helper functions

function formatArgs(firstArg) {
  if (typeof firstArg === 'function') {
    firstArg = firstArg();
  }

  for (var _len5 = arguments.length, args = Array(_len5 > 1 ? _len5 - 1 : 0), _key5 = 1; _key5 < _len5; _key5++) {
    args[_key5 - 1] = arguments[_key5];
  }

  if (typeof firstArg === 'string') {
    args.unshift('deck.gl ' + firstArg);
  } else {
    args.unshift(firstArg);
    args.unshift('deck.gl');
  }
  return args;
}

// Assertions don't generate standard exceptions and don't print nicely
function checkForAssertionErrors(args) {
  var isAssertion = args && args.length > 0 && _typeof(args[0]) === 'object' && args[0] !== null && args[0].name === 'AssertionError';

  if (isAssertion) {
    args = Array.prototype.slice.call(args);
    args.unshift('assert(' + args[0].message + ')');
  }
  return args;
}

log.priority = 0;
log.log = log;
log.once = once;
log.time = time;
log.timeEnd = timeEnd;
log.warn = warn;
log.error = error;
log.deprecated = deprecated;
log.removed = removed;
log.group = group;
log.groupEnd = groupEnd;

export default log;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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