var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Linear scale maps continuous domain to continuous range
export function linearScale(domain, range, value) {
  return (value - domain[0]) / (domain[1] - domain[0]) * (range[1] - range[0]) + range[0];
}

// Quantize scale is similar to linear scales,
// except it uses a discrete rather than continuous range
export function quantizeScale(domain, range, value) {
  var step = (domain[1] - domain[0]) / range.length;
  var idx = Math.floor((value - domain[0]) / step);
  var clampIdx = Math.max(Math.min(idx, range.length - 1), 0);

  return range[clampIdx];
}

// return a quantize scale function
export function getQuantizeScale(domain, range) {
  return function (value) {
    var step = (domain[1] - domain[0]) / range.length;
    var idx = Math.floor((value - domain[0]) / step);
    var clampIdx = Math.max(Math.min(idx, range.length - 1), 0);

    return range[clampIdx];
  };
}

// return a linear scale funciton
export function getLinearScale(domain, range) {
  return function (value) {
    return (value - domain[0]) / (domain[1] - domain[0]) * (range[1] - range[0]) + range[0];
  };
}

export function clamp(_ref, value) {
  var _ref2 = _slicedToArray(_ref, 2),
      min = _ref2[0],
      max = _ref2[1];

  return Math.min(max, Math.max(min, value));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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