var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _toConsumableArray(arr) { if (Array.isArray(arr)) { for (var i = 0, arr2 = Array(arr.length); i < arr.length; i++) { arr2[i] = arr[i]; } return arr2; } else { return Array.from(arr); } }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import Viewport from './viewport';

import { createMat4, transformVector } from '../utils/math-utils';

import mat4_multiply from 'gl-mat4/multiply';
import mat4_lookAt from 'gl-mat4/lookAt';
import mat4_scale from 'gl-mat4/scale';
import mat4_perspective from 'gl-mat4/perspective';
import mat4_translate from 'gl-mat4/translate';
import mat4_rotateX from 'gl-mat4/rotateX';
import mat4_rotateY from 'gl-mat4/rotateY';
import mat4_rotateZ from 'gl-mat4/rotateZ';

var DEGREES_TO_RADIANS = Math.PI / 180;

/*
 * A deck.gl Viewport class used by OrbitController
 * Adds zoom and pixel translation on top of the PerspectiveViewport
 */

var OrbitViewport = function (_Viewport) {
  _inherits(OrbitViewport, _Viewport);

  function OrbitViewport(_ref) {
    var _ref$id = _ref.id,
        id = _ref$id === undefined ? 'orbit-viewport' : _ref$id,
        width = _ref.width,
        height = _ref.height,
        distance = _ref.distance,
        _ref$rotationX = _ref.rotationX,
        rotationX = _ref$rotationX === undefined ? 0 : _ref$rotationX,
        _ref$rotationOrbit = _ref.rotationOrbit,
        rotationOrbit = _ref$rotationOrbit === undefined ? 0 : _ref$rotationOrbit,
        _ref$orbitAxis = _ref.orbitAxis,
        orbitAxis = _ref$orbitAxis === undefined ? 'Z' : _ref$orbitAxis,
        _ref$lookAt = _ref.lookAt,
        lookAt = _ref$lookAt === undefined ? [0, 0, 0] : _ref$lookAt,
        _ref$up = _ref.up,
        up = _ref$up === undefined ? [0, 1, 0] : _ref$up,
        _ref$fov = _ref.fov,
        fov = _ref$fov === undefined ? 75 : _ref$fov,
        _ref$near = _ref.near,
        near = _ref$near === undefined ? 1 : _ref$near,
        _ref$far = _ref.far,
        far = _ref$far === undefined ? 100 : _ref$far,
        _ref$zoom = _ref.zoom,
        zoom = _ref$zoom === undefined ? 1 : _ref$zoom;

    _classCallCheck(this, OrbitViewport);

    var rotationMatrix = mat4_rotateX([], createMat4(), -rotationX / 180 * Math.PI);
    if (orbitAxis === 'Z') {
      mat4_rotateZ(rotationMatrix, rotationMatrix, -rotationOrbit / 180 * Math.PI);
    } else {
      mat4_rotateY(rotationMatrix, rotationMatrix, -rotationOrbit / 180 * Math.PI);
    }

    var translateMatrix = createMat4();
    mat4_scale(translateMatrix, translateMatrix, [zoom, zoom, zoom]);
    mat4_translate(translateMatrix, translateMatrix, [-lookAt[0], -lookAt[1], -lookAt[2]]);

    var viewMatrix = mat4_lookAt([], [0, 0, distance], [0, 0, 0], up);
    var fovRadians = fov * DEGREES_TO_RADIANS;
    var aspect = width / height;
    var perspectiveMatrix = mat4_perspective([], fovRadians, aspect, near, far);

    var _this = _possibleConstructorReturn(this, (OrbitViewport.__proto__ || Object.getPrototypeOf(OrbitViewport)).call(this, {
      id: id,
      viewMatrix: mat4_multiply(viewMatrix, viewMatrix, mat4_multiply(rotationMatrix, rotationMatrix, translateMatrix)),
      projectionMatrix: perspectiveMatrix,
      width: width,
      height: height
    }));

    _this.width = width;
    _this.height = height;
    _this.distance = distance;
    _this.rotationX = rotationX;
    _this.rotationOrbit = rotationOrbit;
    _this.orbitAxis = orbitAxis;
    _this.lookAt = lookAt;
    _this.up = up;
    _this.fov = fov;
    _this.near = near;
    _this.far = far;
    _this.zoom = zoom;
    return _this;
  }

  _createClass(OrbitViewport, [{
    key: 'project',
    value: function project(xyz) {
      var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref2$topLeft = _ref2.topLeft,
          topLeft = _ref2$topLeft === undefined ? false : _ref2$topLeft;

      var v = transformVector(this.pixelProjectionMatrix, [].concat(_toConsumableArray(xyz), [1]));

      var _v = _slicedToArray(v, 3),
          x = _v[0],
          y = _v[1],
          z = _v[2];

      var y2 = topLeft ? this.height - y : y;
      return [x, y2, z];
    }
  }, {
    key: 'unproject',
    value: function unproject(xyz) {
      var _ref3 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
          _ref3$topLeft = _ref3.topLeft,
          topLeft = _ref3$topLeft === undefined ? false : _ref3$topLeft;

      var _xyz = _slicedToArray(xyz, 3),
          x = _xyz[0],
          y = _xyz[1],
          z = _xyz[2];

      var y2 = topLeft ? this.height - y : y;

      return transformVector(this.pixelUnprojectionMatrix, [x, y2, z, 1]);
    }

    /** Move camera to make a model bounding box centered at lookat position fit in the viewport.
     * @param {Array} sizes - [sizeX, sizeY, sizeZ]], define the dimensions of bounding box
     * @returns a new OrbitViewport object
     */

  }, {
    key: 'fitBounds',
    value: function fitBounds(sizes) {
      var width = this.width,
          height = this.height,
          rotationX = this.rotationX,
          rotationOrbit = this.rotationOrbit,
          orbitAxis = this.orbitAxis,
          lookAt = this.lookAt,
          up = this.up,
          fov = this.fov,
          near = this.near,
          far = this.far,
          zoom = this.zoom;

      var size = Math.max(sizes[0], sizes[1], sizes[2]) / 2;
      var newDistance = size / Math.tan(fov / 180 * Math.PI / 2);

      return new OrbitViewport({
        width: width,
        height: height,
        rotationX: rotationX,
        rotationOrbit: rotationOrbit,
        orbitAxis: orbitAxis,
        up: up,
        fov: fov,
        near: near,
        far: far,
        zoom: zoom,
        lookAt: lookAt,
        distance: newDistance
      });
    }
  }]);

  return OrbitViewport;
}(Viewport);

export default OrbitViewport;


OrbitViewport.displayName = 'OrbitViewport';
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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