var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

// Note: This file will either be moved back to deck.gl or reformatted to web-monorepo standards
// Disabling lint temporarily to facilitate copying code in and out of this repo
/* eslint-disable */

// Copyright (c) 2015 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

import { Layer, COORDINATE_SYSTEM, experimental } from 'deck.gl';
var fp64LowPart = experimental.fp64LowPart,
    enable64bitSupport = experimental.enable64bitSupport;

import { GL, Model, Geometry, loadTextures, Texture2D } from 'luma.gl';
import assert from 'assert';

import vs from './mesh-layer-vertex.glsl';
import vs64 from './mesh-layer-vertex-64.glsl';
import fs from './mesh-layer-fragment.glsl';
import project64utils from '../shaderlib/project64utils/project64utils';

function degreeToRadian(degree) {
  return degree * Math.PI / 180;
}

/*
 * Load image data into luma.gl Texture2D objects
 * @param {WebGLContext} gl
 * @param {String|Texture2D|HTMLImageElement|Uint8ClampedArray} src - source of image data
 *   can be url string, Texture2D object, HTMLImageElement or pixel array
 * @returns {Promise} resolves to an object with name -> texture mapping
 */
function getTexture(gl, src, opts) {
  if (typeof src === 'string') {
    // Url, load the image
    return loadTextures(gl, Object.assign({ urls: [src] }, opts)).then(function (textures) {
      return textures[0];
    }).catch(function (error) {
      throw new Error('Could not load texture from ' + src + ': ' + error);
    });
  }
  return new Promise(function (resolve) {
    return resolve(getTextureFromData(gl, src, opts));
  });
}

/*
 * Convert image data into texture
 * @returns {Texture2D} texture
 */
function getTextureFromData(gl, data, opts) {
  if (data instanceof Texture2D) {
    return data;
  }
  return new Texture2D(gl, Object.assign({ data: data }, opts));
}

var defaultProps = {
  mesh: null,
  texture: null,
  sizeScale: 1,

  // TODO - parameters should be merged, not completely overridden
  parameters: {
    depthTest: true,
    depthFunc: GL.LEQUAL
  },
  fp64: false,
  // Optional settings for 'lighting' shader module
  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.05,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [2.0, 0.0, 0.0, 0.0],
    numberOfLights: 2
  },

  getPosition: function getPosition(x) {
    return x.position;
  },
  getAngleDegreesCW: function getAngleDegreesCW(x) {
    return x.angle || 0;
  },
  getColor: function getColor(x) {
    return x.color || [0, 0, 0, 255];
  }
};

var MeshLayer = function (_Layer) {
  _inherits(MeshLayer, _Layer);

  function MeshLayer() {
    _classCallCheck(this, MeshLayer);

    return _possibleConstructorReturn(this, (MeshLayer.__proto__ || Object.getPrototypeOf(MeshLayer)).apply(this, arguments));
  }

  _createClass(MeshLayer, [{
    key: 'getShaders',
    value: function getShaders(id) {
      var shaderCache = this.context.shaderCache;

      return enable64bitSupport(this.props) ? { vs: vs64, fs: fs, modules: [project64utils, 'picking', 'lighting'], shaderCache: shaderCache } : { vs: vs, fs: fs, modules: ['picking', 'lighting'], shaderCache: shaderCache }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          accessor: 'getPosition',
          update: this.calculateInstancePositions
        },
        instanceAngles: {
          size: 1,
          accessor: 'getAngleDegreesCW',
          update: this.calculateInstanceAngles
        },
        instanceColors: { size: 4, accessor: 'getColor', update: this.calculateInstanceColors }
      });
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      var attributeManager = this.getAttributeManager();

      // super.updateState({props, oldProps, changeFlags});
      if (changeFlags.dataChanged) {
        attributeManager.invalidateAll();
      }

      if (changeFlags.propsChanged) {
        this._updateFP64(props, oldProps);

        if (props.sizeScale !== oldProps.sizeScale) {
          var sizeScale = props.sizeScale;

          this.state.model.setUniforms({ sizeScale: sizeScale });
        }

        if (props.texture !== oldProps.texture) {
          if (props.texture) {
            this.loadTexture(props.texture);
          } else {
            // TODO - reset
          }
        }

        if (props.lightSettings !== oldProps.lightSettings) {
          this.state.model.setUniforms(props.lightSettings);
        }
      }
    }
  }, {
    key: '_updateFP64',
    value: function _updateFP64(props, oldProps) {
      if (props.fp64 !== oldProps.fp64) {
        this.setState({ model: this.getModel(this.context.gl) });

        this.state.model.setUniforms({
          sizeScale: props.sizeScale
        });

        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (enable64bitSupport(this.props)) {
          attributeManager.addInstanced({
            instancePositions64xy: {
              size: 2,
              accessor: 'getPosition',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xy']);
        }
      }
    }
  }, {
    key: 'draw',
    value: function draw(_ref2) {
      var uniforms = _ref2.uniforms;

      this.state.model.render(uniforms);
    }
  }, {
    key: 'getModel',
    value: function getModel(gl) {
      var isValidMesh = this.props.mesh instanceof Geometry && this.props.mesh.attributes.positions;
      assert(isValidMesh);

      return new Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: this.props.mesh,
        isInstanced: true
      }));
    }
  }, {
    key: 'loadTexture',
    value: function loadTexture(src) {
      var _this2 = this;

      var gl = this.context.gl;
      var model = this.state.model;

      getTexture(gl, src).then(function (texture) {
        model.setUniforms({ sampler1: texture });
        _this2.setNeedsRedraw();
      });
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props = this.props,
          data = _props.data,
          getPosition = _props.getPosition;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var point = _step.value;

          var position = getPosition(point);
          value[i] = position[0];
          value[i + 1] = position[1];
          value[i + 2] = position[2] || 0;
          i += size;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getPosition = _props2.getPosition;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var point = _step2.value;

          var position = getPosition(point);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceAngles',
    value: function calculateInstanceAngles(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getAngleDegreesCW = _props3.getAngleDegreesCW;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var point = _step3.value;

          var angle = getAngleDegreesCW(point);
          value[i] = -degreeToRadian(angle);
          i += size;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion4 = true;
      var _didIteratorError4 = false;
      var _iteratorError4 = undefined;

      try {
        for (var _iterator4 = data[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
          var point = _step4.value;

          var color = getColor(point) || DEFAULT_COLOR;
          value[i++] = color[0];
          value[i++] = color[1];
          value[i++] = color[2];
          value[i++] = isNaN(color[3]) ? 255 : color[3];
        }
      } catch (err) {
        _didIteratorError4 = true;
        _iteratorError4 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion4 && _iterator4.return) {
            _iterator4.return();
          }
        } finally {
          if (_didIteratorError4) {
            throw _iteratorError4;
          }
        }
      }
    }
  }]);

  return MeshLayer;
}(Layer);

export default MeshLayer;


MeshLayer.layerName = 'MeshLayer';
MeshLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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