var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import { CompositeLayer, ScatterplotLayer, COORDINATE_SYSTEM } from 'deck.gl';
import PathOutlineLayer from '../path-outline-layer/path-outline-layer';
import MeshLayer from '../mesh-layer/mesh-layer';
import Arrow2DGeometry from './arrow-2d-geometry';

import createPathMarkers from './create-path-markers';
import { getClosestPointOnPolyline } from './polyline';

var DISTANCE_FOR_MULTI_ARROWS = 0.1;
var ARROW_HEAD_SIZE = 0.2;
var ARROW_TAIL_WIDTH = 0.05;
// const ARROW_CENTER_ADJUST = -0.8;

var DEFAULT_MARKER_LAYER = MeshLayer;

var DEFAULT_MARKER_LAYER_PROPS = {
  mesh: new Arrow2DGeometry({ headSize: ARROW_HEAD_SIZE, tailWidth: ARROW_TAIL_WIDTH })
};

var defaultProps = Object.assign({}, PathOutlineLayer.defaultProps, {
  MarkerLayer: DEFAULT_MARKER_LAYER,
  markerLayerProps: DEFAULT_MARKER_LAYER_PROPS,

  sizeScale: 100,
  fp64: false,

  hightlightIndex: -1,
  highlightPoint: null,

  getPath: function getPath(x) {
    return x.path;
  },
  getColor: function getColor(x) {
    return x.color;
  },
  getMarkerColor: function getMarkerColor(x) {
    return [0, 0, 0, 255];
  },
  getDirection: function getDirection(x) {
    return x.direction;
  },
  getMarkerPercentages: function getMarkerPercentages(object, _ref) {
    var lineLength = _ref.lineLength;
    return lineLength > DISTANCE_FOR_MULTI_ARROWS ? [0.25, 0.5, 0.75] : [0.5];
  }
});

var PathMarkerLayer = function (_CompositeLayer) {
  _inherits(PathMarkerLayer, _CompositeLayer);

  function PathMarkerLayer() {
    _classCallCheck(this, PathMarkerLayer);

    return _possibleConstructorReturn(this, (PathMarkerLayer.__proto__ || Object.getPrototypeOf(PathMarkerLayer)).apply(this, arguments));
  }

  _createClass(PathMarkerLayer, [{
    key: 'initializeState',
    value: function initializeState() {
      this.state = {
        markers: [],
        mesh: new Arrow2DGeometry({ headSize: ARROW_HEAD_SIZE, tailWidth: ARROW_TAIL_WIDTH }),
        closestPoint: null
      };
    }
  }, {
    key: 'projectFlat',
    value: function projectFlat(xyz, viewport, coordinateSystem, coordinateOrigin) {
      if (coordinateSystem === COORDINATE_SYSTEM.METER_OFFSETS) {
        var _viewport$metersToLng = viewport.metersToLngLatDelta(xyz),
            _viewport$metersToLng2 = _slicedToArray(_viewport$metersToLng, 2),
            dx = _viewport$metersToLng2[0],
            dy = _viewport$metersToLng2[1];

        var _coordinateOrigin = _slicedToArray(coordinateOrigin, 2),
            x = _coordinateOrigin[0],
            y = _coordinateOrigin[1];

        return viewport.projectFlat([x - dx, dy + y]);
      }

      return viewport.projectFlat(xyz);
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var _this2 = this;

      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      if (changeFlags.dataChanged) {
        var _props = this.props,
            data = _props.data,
            getPath = _props.getPath,
            getDirection = _props.getDirection,
            getMarkerColor = _props.getMarkerColor,
            getMarkerPercentages = _props.getMarkerPercentages,
            coordinateSystem = _props.coordinateSystem,
            coordinateOrigin = _props.coordinateOrigin;
        var viewport = this.context.viewport;

        var projectFlat = function projectFlat(o) {
          return _this2.projectFlat(o, viewport, coordinateSystem, coordinateOrigin);
        };
        this.state.markers = createPathMarkers({
          data: data,
          getPath: getPath,
          getDirection: getDirection,
          getColor: getMarkerColor,
          getMarkerPercentages: getMarkerPercentages,
          projectFlat: projectFlat
        });
        this._recalculateClosestPoint();
      }
      if (changeFlags.propsChanged) {
        if (props.point !== oldProps.point) {
          this._recalculateClosestPoint();
        }
      }
    }
  }, {
    key: '_recalculateClosestPoint',
    value: function _recalculateClosestPoint() {
      var _props2 = this.props,
          highlightPoint = _props2.highlightPoint,
          highlightIndex = _props2.highlightIndex;

      if (highlightPoint && highlightIndex >= 0) {
        var object = this.props.data[highlightIndex];
        var points = this.props.getPath(object);

        var _getClosestPointOnPol = getClosestPointOnPolyline({ points: points, p: highlightPoint }),
            point = _getClosestPointOnPol.point;

        this.state.closestPoints = [{
          position: point
        }];
      } else {
        this.state.closestPoints = [];
      }
    }
  }, {
    key: 'getPickingInfo',
    value: function getPickingInfo(_ref3) {
      var info = _ref3.info;

      return Object.assign(info, {
        // override object with picked feature
        object: info.object && info.object.path || info.object
      });
    }
  }, {
    key: 'renderLayers',
    value: function renderLayers() {
      return [new PathOutlineLayer(this.getSubLayerProps(Object.assign({}, this.props, {
        id: 'paths',
        fp64: this.props.fp64
      }))), new this.props.MarkerLayer(this.getSubLayerProps(Object.assign({}, this.props.markerLayerProps, {
        id: 'markers',
        data: this.state.markers,
        sizeScale: this.props.sizeScale,
        fp64: this.props.fp64,
        pickable: false,
        parameters: {
          blend: false,
          depthTest: false
        }
      }))), this.state.closestPoints && new ScatterplotLayer({
        id: this.props.id + '-highlight',
        data: this.state.closestPoints,
        fp64: this.props.fp64
      })];
    }
  }]);

  return PathMarkerLayer;
}(CompositeLayer);

export default PathMarkerLayer;


PathMarkerLayer.layerName = 'PathMarkerLayer';
PathMarkerLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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