// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

export default "#define SHADER_NAME multi-icon-layer-vertex-shader-64\n\nattribute vec2 positions;\n\nattribute vec3 instancePositions;\nattribute vec2 instancePositions64xyLow;\nattribute float instanceSizes;\nattribute float instanceAngles;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\nattribute vec4 instanceIconFrames;\nattribute float instanceColorModes;\nattribute vec2 instanceOffsets;\n\n// the following three attributes are for the multi-icon layer\nattribute float instanceIndexOfIcon;\nattribute float instanceNumOfIcon;\nattribute vec2 instancePixelOffset;\n\nuniform float sizeScale;\nuniform vec2 iconsTextureDim;\n\nvarying float vColorMode;\nvarying vec4 vColor;\nvarying vec2 vTextureCoords;\n\nvec2 rotate_by_angle(vec2 vertex, float angle) {\n  float angle_radian = angle * PI / 180.0;\n  float cos_angle = cos(angle_radian);\n  float sin_angle = sin(angle_radian);\n  mat2 rotationMatrix = mat2(cos_angle, -sin_angle, sin_angle, cos_angle);\n  return rotationMatrix * vertex;\n}\n\nvec2 getShift(float instanceIndexOfIcon, float instanceNumOfIcon) {\n  // calculate the middle index of the string\n  float midIndex = (instanceNumOfIcon - 1.0) / 2.0;\n  // calculate horizontal shift of each letter\n  return vec2(instanceIndexOfIcon - midIndex, 0.0);\n}\n\nvoid main(void) {\n  vec2 iconSize = instanceIconFrames.zw;\n  // scale icon height to match instanceSize\n  float instanceScale = iconSize.y == 0.0 ? 0.0 : instanceSizes / iconSize.y;\n\n  // scale and rotate vertex in \"pixel\" value and convert back to fraction in clipspace\n  vec2 shift = getShift(instanceIndexOfIcon, instanceNumOfIcon);\n  vec2 pixelOffset = (positions / 2.0 + shift) * iconSize + instanceOffsets;\n\n  pixelOffset = rotate_by_angle(pixelOffset, instanceAngles) * sizeScale * instanceScale;\n  pixelOffset += instancePixelOffset;\n  pixelOffset.y *= -1.0;\n\n  vec4 instancePositions64xy = vec4(\n  instancePositions.x, instancePositions64xyLow.x,\n  instancePositions.y, instancePositions64xyLow.y);\n\n  vec2 projected_coord_xy[2];\n  project_position_fp64(instancePositions64xy, projected_coord_xy);\n\n  vec2 vertex_pos_modelspace[4];\n  vertex_pos_modelspace[0] = projected_coord_xy[0];\n  vertex_pos_modelspace[1] = projected_coord_xy[1];\n  vertex_pos_modelspace[2] = vec2(project_scale(instancePositions.z), 0.0);\n  vertex_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  gl_Position = project_to_clipspace_fp64(vertex_pos_modelspace);\n  gl_Position += project_pixel_to_clipspace(pixelOffset);\n\n  vTextureCoords = mix(\n    instanceIconFrames.xy,\n    instanceIconFrames.xy + iconSize,\n    (positions.xy + 1.0) / 2.0\n  ) / iconsTextureDim;\n\n  vTextureCoords.y = 1.0 - vTextureCoords.y;\n\n  vColor = instanceColors / 255.;\n  picking_setPickingColor(instancePickingColors);\n\n  vColorMode = instanceColorModes;\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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