// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Enables ES2015 import/export in Node.js
require('reify');

// Registers an alias for this module
var path = require('path');
var moduleAlias = require('module-alias');
moduleAlias.addAlias('deck.gl-layers/test', path.resolve('./test'));
moduleAlias.addAlias('deck.gl-layers', path.resolve('./src'));

require('babel-polyfill');

// Import headless luma support
require('luma.gl/headless');

// Run the tests
require('../../../test/src/experimental-layers');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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