var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; }

import React, { createElement, cloneElement } from 'react';
import { flatten } from '../../core/utils/flatten';

var ViewportLayout = function (_React$Component) {
  _inherits(ViewportLayout, _React$Component);

  function ViewportLayout(props) {
    _classCallCheck(this, ViewportLayout);

    return _possibleConstructorReturn(this, (ViewportLayout.__proto__ || Object.getPrototypeOf(ViewportLayout)).call(this, props));
  }

  // Iterate over viewport descriptors and render viewports at specified positions


  _createClass(ViewportLayout, [{
    key: '_renderChildrenUnderViewports',
    value: function _renderChildrenUnderViewports() {
      // Flatten out nested viewports array
      var viewports = flatten(this.props.viewports, { filter: Boolean });

      // Build a viewport id to viewport index
      var viewportMap = {};
      viewports.forEach(function (viewportOrDescriptor) {
        var viewport = viewportOrDescriptor.viewport || viewportOrDescriptor;
        if (viewport.id) {
          viewportMap[viewport.id] = viewport;
        }
      });

      var originalChildren = React.Children.toArray(this.props.children);
      var lastElement = originalChildren.pop();

      var children = originalChildren.map(function (child, i) {
        // If viewportId is provided, match with viewport
        if (child.props.viewportId) {
          var viewport = viewportMap[child.props.viewportId];

          // TODO - this is too react-map-gl specific
          var newProps = Object.assign({}, child.props, {
            visible: viewport.isMapSynched(),
            width: viewport.width,
            height: viewport.height
          }, viewport.getMercatorParams());

          var clone = cloneElement(child, newProps);

          var _style = {
            position: 'absolute',
            left: viewport.x,
            top: viewport.y,
            width: viewport.width,
            height: viewport.height
          };

          child = createElement('div', { key: 'viewport-component-' + i, style: _style }, clone);
        }

        return child;
      });

      var style = { position: 'absolute', left: 0, top: 0 };
      children.push(createElement('div', { key: 'children', style: style }, lastElement));

      return children;
    }
  }, {
    key: 'render',
    value: function render() {
      // Render the background elements (typically react-map-gl instances)
      // using the viewport descriptors
      var children = this._renderChildrenUnderViewports();
      return createElement('div', {}, children);
    }
  }]);

  return ViewportLayout;
}(React.Component);

export default ViewportLayout;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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