'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isWebglAvailable = undefined;

require('luma.gl');

var _globals = require('../utils/globals');

/* eslint-disable quotes, no-console */
/* global console */
var ERR_NO_HEADLESS_GL = 'Failed to dynamically load headless gl. gl not installed or not accessible from this directory.';

var luma = _globals.global.luma;
if (!_globals.isBrowser) {
  try {
    luma.globals.headlessGL = module.require('gl');
    luma.globals.headlessTypes = module.require('gl/wrap');
  } catch (error) {
    console.error(ERR_NO_HEADLESS_GL);
    console.error('Node error: ' + error.message);
  }
  var _luma$globals = luma.globals,
      headlessGL = _luma$globals.headlessGL,
      headlessTypes = _luma$globals.headlessTypes;

  if (headlessGL && !(headlessTypes && headlessTypes.WebGLRenderingContext)) {
    console.error('Could not access headless WebGL type definitions');
  }
}

var isWebglAvailable = exports.isWebglAvailable = _globals.isBrowser || luma.globals.headlessGL;

if (isWebglAvailable) {}
// console.log('WebGL initialized');


// Create context
exports.default = luma.globals.headlessGL;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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