'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createImage = createImage;
exports.getImageFromContext = getImageFromContext;
exports.getImagePixelData = getImagePixelData;
// TODO - only works in browser
/* global document */

function createImage(width, height) {
  var image = document.createElement('img');
  image.width = width;
  image.height = height;
  image.style.position = 'absolute';
  image.style.top = 0;
  image.style.left = 0;
  return image;
}

function getImageFromContext(gl) {
  var image = createImage(gl.drawingBufferWidth, gl.drawingBufferHeight);
  return new Promise(function (resolve) {
    image.onload = function () {
      resolve(image);
    };
    image.src = gl.canvas.toDataURL();
  });
}

function getImagePixelData(image) {
  var width = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  width = width || image.width;
  height = height || image.height;

  var canvas = document.createElement('canvas');
  canvas.width = width;
  canvas.height = height;
  var ctx = canvas.getContext('2d');
  ctx.drawImage(image, 0, 0, width, height);
  return ctx.getImageData(0, 0, width, height);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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