'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadImage = loadImage;

var _pathPrefix = require('./path-prefix');

/* global Image */

/*
 * Loads images asynchronously
 * image.crossOrigin can be set via opts.crossOrigin, default to 'anonymous'
 * returns a promise tracking the load
 */
function loadImage(url, opts) {
  var pathPrefix = (0, _pathPrefix.getPathPrefix)();
  url = pathPrefix ? pathPrefix + url : url;

  return new Promise(function (resolve, reject) {
    try {
      var image = new Image();
      image.onload = function () {
        return resolve(image);
      };
      image.onerror = function () {
        return reject(new Error('Could not load image ' + url + '.'));
      };
      image.crossOrigin = opts && opts.crossOrigin || 'anonymous';
      image.src = url;
    } catch (error) {
      reject(error);
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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