'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.writeFile = writeFile;

var _utils = require('../../utils');

// TODO hack - trick filesaver.js to skip loading under node
/* global global*/
var savedNavigatorExists = 'navigator' in global; // A browser implementation of the Node.js `fs` module's `fs.writeFile` method.

var savedNavigator = global.navigator;
if (!_utils.isBrowser) {
  global.navigator = { userAgent: 'MSIE 9.' };
}

// Need to use `require` to ensure our modification of global code above happens first
var saveAs = require('filesaver.js');

if (!_utils.isBrowser) {
  if (savedNavigatorExists) {
    global.navigator = savedNavigator;
  } else {
    delete global.navigator;
  }
}
// END hack

var window = require('global/window');
var Blob = window.Blob;

/**
 * File system write function for the browser, similar to Node's fs.writeFile
 *
 * Saves a file by downloading it with the given file name.
 *
 * @param {String} file - file name
 * @param {String|Blob} data - data to be written to file
 * @param {String|Object} options -
 * @param {Function} callback - Standard node (err, data) callback
 * @return {Promise} - promise, can be used instead of callback
 */
function writeFile(file, data, options) {
  var callback = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : function () {};

  // options is optional
  if (callback === undefined && typeof options === 'function') {
    options = undefined;
    callback = options;
  }
  if (typeof data === 'string') {
    data = new Blob(data);
  }
  return new Promise(function (resolve, reject) {
    var result = void 0;
    try {
      result = saveAs(data, file, options);
    } catch (error) {
      reject(error);
      return callback(error, null);
    }
    resolve();
    return callback(null, result);
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9sdW1hLmdsL2lvLWV4dGVuZGVkL2Jyb3dzZXItd3JpdGUtZmlsZS5qcyJdLCJuYW1lcyI6WyJ3cml0ZUZpbGUiLCJzYXZlZE5hdmlnYXRvckV4aXN0cyIsImdsb2JhbCIsInNhdmVkTmF2aWdhdG9yIiwibmF2aWdhdG9yIiwidXNlckFnZW50Iiwic2F2ZUFzIiwicmVxdWlyZSIsIndpbmRvdyIsIkJsb2IiLCJmaWxlIiwiZGF0YSIsIm9wdGlvbnMiLCJjYWxsYmFjayIsInVuZGVmaW5lZCIsIlByb21pc2UiLCJyZXNvbHZlIiwicmVqZWN0IiwicmVzdWx0IiwiZXJyb3IiXSwibWFwcGluZ3MiOiI7Ozs7O1FBc0NnQixBLFksQUFBQTs7QUFwQ2hCOztBQUVBO0FBQ0E7QUFDQSxJQUFNLHVCQUF1QixlQUE3QixBLEFBQTRDLFFBTjVDOztBQU9BLElBQU0saUJBQWlCLE9BQXZCLEFBQThCO0FBQzlCLElBQUksUUFBSixXQUFnQixBQUNkO1NBQUEsQUFBTyxZQUFZLEVBQUMsV0FBcEIsQUFBbUIsQUFBWSxBQUNoQzs7O0FBRUQ7QUFDQSxJQUFNLFNBQVMsUUFBZixBQUFlLEFBQVE7O0FBRXZCLElBQUksUUFBSixXQUFnQixBQUNkO01BQUEsQUFBSSxzQkFBc0IsQUFDeEI7V0FBQSxBQUFPLFlBQVAsQUFBbUIsQUFDcEI7QUFGRCxTQUVPLEFBQ0w7V0FBTyxPQUFQLEFBQWMsQUFDZjtBQUNGOztBQUNEOztBQUVBLElBQU0sU0FBUyxRQUFmLEFBQWUsQUFBUTtBQUN2QixJQUFNLE9BQU8sT0FBYixBQUFvQjs7QUFFcEI7Ozs7Ozs7Ozs7O0FBV08sU0FBQSxBQUFTLFVBQVQsQUFBbUIsTUFBbkIsQUFBeUIsTUFBekIsQUFBK0IsU0FBOEI7TUFBckIsQUFBcUIsK0VBQVYsWUFBTSxBQUFFLENBQUUsQUFDbEU7O0FBQ0E7TUFBSSxhQUFBLEFBQWEsYUFBYSxPQUFBLEFBQU8sWUFBckMsQUFBaUQsWUFBWSxBQUMzRDtjQUFBLEFBQVUsQUFDVjtlQUFBLEFBQVcsQUFDWjtBQUNEO01BQUksT0FBQSxBQUFPLFNBQVgsQUFBb0IsVUFBVSxBQUM1QjtXQUFPLElBQUEsQUFBSSxLQUFYLEFBQU8sQUFBUyxBQUNqQjtBQUNEO2FBQU8sQUFBSSxRQUFRLFVBQUEsQUFBQyxTQUFELEFBQVUsUUFBVyxBQUN0QztRQUFJLGNBQUosQUFDQTtRQUFJLEFBQ0Y7ZUFBUyxPQUFBLEFBQU8sTUFBUCxBQUFhLE1BQXRCLEFBQVMsQUFBbUIsQUFDN0I7QUFGRCxNQUVFLE9BQUEsQUFBTyxPQUFPLEFBQ2Q7YUFBQSxBQUFPLEFBQ1A7YUFBTyxTQUFBLEFBQVMsT0FBaEIsQUFBTyxBQUFnQixBQUN4QjtBQUNEO0FBQ0E7V0FBTyxTQUFBLEFBQVMsTUFBaEIsQUFBTyxBQUFlLEFBQ3ZCO0FBVkQsQUFBTyxBQVdSLEdBWFEiLCJmaWxlIjoiYnJvd3Nlci13cml0ZS1maWxlLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQSBicm93c2VyIGltcGxlbWVudGF0aW9uIG9mIHRoZSBOb2RlLmpzIGBmc2AgbW9kdWxlJ3MgYGZzLndyaXRlRmlsZWAgbWV0aG9kLlxuXG5pbXBvcnQge2lzQnJvd3Nlcn0gZnJvbSAnLi4vLi4vdXRpbHMnO1xuXG4vLyBUT0RPIGhhY2sgLSB0cmljayBmaWxlc2F2ZXIuanMgdG8gc2tpcCBsb2FkaW5nIHVuZGVyIG5vZGVcbi8qIGdsb2JhbCBnbG9iYWwqL1xuY29uc3Qgc2F2ZWROYXZpZ2F0b3JFeGlzdHMgPSAnbmF2aWdhdG9yJyBpbiBnbG9iYWw7XG5jb25zdCBzYXZlZE5hdmlnYXRvciA9IGdsb2JhbC5uYXZpZ2F0b3I7XG5pZiAoIWlzQnJvd3Nlcikge1xuICBnbG9iYWwubmF2aWdhdG9yID0ge3VzZXJBZ2VudDogJ01TSUUgOS4nfTtcbn1cblxuLy8gTmVlZCB0byB1c2UgYHJlcXVpcmVgIHRvIGVuc3VyZSBvdXIgbW9kaWZpY2F0aW9uIG9mIGdsb2JhbCBjb2RlIGFib3ZlIGhhcHBlbnMgZmlyc3RcbmNvbnN0IHNhdmVBcyA9IHJlcXVpcmUoJ2ZpbGVzYXZlci5qcycpO1xuXG5pZiAoIWlzQnJvd3Nlcikge1xuICBpZiAoc2F2ZWROYXZpZ2F0b3JFeGlzdHMpIHtcbiAgICBnbG9iYWwubmF2aWdhdG9yID0gc2F2ZWROYXZpZ2F0b3I7XG4gIH0gZWxzZSB7XG4gICAgZGVsZXRlIGdsb2JhbC5uYXZpZ2F0b3I7XG4gIH1cbn1cbi8vIEVORCBoYWNrXG5cbmNvbnN0IHdpbmRvdyA9IHJlcXVpcmUoJ2dsb2JhbC93aW5kb3cnKTtcbmNvbnN0IEJsb2IgPSB3aW5kb3cuQmxvYjtcblxuLyoqXG4gKiBGaWxlIHN5c3RlbSB3cml0ZSBmdW5jdGlvbiBmb3IgdGhlIGJyb3dzZXIsIHNpbWlsYXIgdG8gTm9kZSdzIGZzLndyaXRlRmlsZVxuICpcbiAqIFNhdmVzIGEgZmlsZSBieSBkb3dubG9hZGluZyBpdCB3aXRoIHRoZSBnaXZlbiBmaWxlIG5hbWUuXG4gKlxuICogQHBhcmFtIHtTdHJpbmd9IGZpbGUgLSBmaWxlIG5hbWVcbiAqIEBwYXJhbSB7U3RyaW5nfEJsb2J9IGRhdGEgLSBkYXRhIHRvIGJlIHdyaXR0ZW4gdG8gZmlsZVxuICogQHBhcmFtIHtTdHJpbmd8T2JqZWN0fSBvcHRpb25zIC1cbiAqIEBwYXJhbSB7RnVuY3Rpb259IGNhbGxiYWNrIC0gU3RhbmRhcmQgbm9kZSAoZXJyLCBkYXRhKSBjYWxsYmFja1xuICogQHJldHVybiB7UHJvbWlzZX0gLSBwcm9taXNlLCBjYW4gYmUgdXNlZCBpbnN0ZWFkIG9mIGNhbGxiYWNrXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiB3cml0ZUZpbGUoZmlsZSwgZGF0YSwgb3B0aW9ucywgY2FsbGJhY2sgPSAoKSA9PiB7fSkge1xuICAvLyBvcHRpb25zIGlzIG9wdGlvbmFsXG4gIGlmIChjYWxsYmFjayA9PT0gdW5kZWZpbmVkICYmIHR5cGVvZiBvcHRpb25zID09PSAnZnVuY3Rpb24nKSB7XG4gICAgb3B0aW9ucyA9IHVuZGVmaW5lZDtcbiAgICBjYWxsYmFjayA9IG9wdGlvbnM7XG4gIH1cbiAgaWYgKHR5cGVvZiBkYXRhID09PSAnc3RyaW5nJykge1xuICAgIGRhdGEgPSBuZXcgQmxvYihkYXRhKTtcbiAgfVxuICByZXR1cm4gbmV3IFByb21pc2UoKHJlc29sdmUsIHJlamVjdCkgPT4ge1xuICAgIGxldCByZXN1bHQ7XG4gICAgdHJ5IHtcbiAgICAgIHJlc3VsdCA9IHNhdmVBcyhkYXRhLCBmaWxlLCBvcHRpb25zKTtcbiAgICB9IGNhdGNoIChlcnJvcikge1xuICAgICAgcmVqZWN0KGVycm9yKTtcbiAgICAgIHJldHVybiBjYWxsYmFjayhlcnJvciwgbnVsbCk7XG4gICAgfVxuICAgIHJlc29sdmUoKTtcbiAgICByZXR1cm4gY2FsbGJhY2sobnVsbCwgcmVzdWx0KTtcbiAgfSk7XG59XG4iXX0=