/*
 * Calculate perceived color difference using YIQ NTSC transmission color space
 * Based on 2010 paper by Yuriy Kotsarenko and Fernando Ramos
 * http://www.progmat.uaem.mx:8080/artVol2Num2/Articulo3Vol2Num2.pdf
 */
var getY = function getY(r, g, b) {
  return r * 0.29889531 + g * 0.58662247 + b * 0.11448223;
};
var getI = function getI(r, g, b) {
  return r * 0.59597799 - g * 0.2741761 - b * 0.32180189;
};
var getQ = function getQ(r, g, b) {
  return r * 0.21147017 - g * 0.52261711 + b * 0.31114694;
};
var getESq = function getESq(dY, dI, dQ) {
  return 0.5053 * dY * dY + 0.299 * dI * dI + 0.1957 * dQ * dQ;
};

// Get blended r/g/b value after applying alpha
var applyAlpha = function applyAlpha(c, a) {
  return 255 + (c - 255) * a / 255;
};

/**
 * Get dE square at given index from two pixel arrays
 * @param {Uint8ClampedArray} img1 - pixel data of first image
 * @param {Uint8ClampedArray} img2 - pixel data of second image
 * @param {Number} i - pixel index
 */
export function colorDelta(img1, img2, index) {
  return Math.sqrt(colorDeltaSq(img1, img2, index));
}

export function colorDeltaSq(img1, img2, index) {
  var i = index * 4;
  var a1 = img1[i + 3];
  var a2 = img2[i + 3];

  var r1 = applyAlpha(img1[i + 0], a1);
  var g1 = applyAlpha(img1[i + 1], a1);
  var b1 = applyAlpha(img1[i + 2], a1);

  var r2 = applyAlpha(img2[i + 0], a2);
  var g2 = applyAlpha(img2[i + 1], a2);
  var b2 = applyAlpha(img2[i + 2], a2);

  return getESq(getY(r1, g1, b1) - getY(r2, g2, b2), getI(r1, g1, b1) - getI(r2, g2, b2), getQ(r1, g1, b1) - getQ(r2, g2, b2));
}

export default colorDeltaSq;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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