/* eslint-disable quotes, no-console */
/* global console */
import 'luma.gl';
import { global, isBrowser } from './utils/globals';

var ERR_NO_HEADLESS_GL = 'Failed to dynamically load headless gl. gl not installed or not accessible from this directory.';

var luma = global.luma;
if (!isBrowser) {
  try {
    luma.globals.headlessGL = module.require('gl');
    luma.globals.headlessTypes = module.require('gl/wrap');
  } catch (error) {
    console.error(ERR_NO_HEADLESS_GL);
    console.error('Node error: ' + error.message);
  }
  var _luma$globals = luma.globals,
      headlessGL = _luma$globals.headlessGL,
      headlessTypes = _luma$globals.headlessTypes;

  if (headlessGL && !(headlessTypes && headlessTypes.WebGLRenderingContext)) {
    console.error('Could not access headless WebGL type definitions');
  }
}

export var isWebglAvailable = isBrowser || luma.globals.headlessGL;

if (isWebglAvailable) {
  console.log('WebGL initialized');
}

// Create context
export default luma.globals.headlessGL;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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