var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

import { loadFile } from './browser-load-file';
import { Program } from '../webgl';
import { Model } from '../core';
import { Geometry } from '../geometry';

// Loads a simple JSON format
export function loadModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  return loadFile(opts).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
        file = _ref2[0];

    return parseModel(gl, Object.assign({ file: file }, opts));
  });
}

export function parseModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var file = opts.file,
      _opts$program = opts.program,
      program = _opts$program === undefined ? new Program(gl) : _opts$program;

  var json = typeof file === 'string' ? parseJSON(file) : file;
  // Remove any attributes so that we can create a geometry
  // TODO - change format to put these in geometry sub object?
  var attributes = {};
  var modelOptions = {};
  for (var key in json) {
    var value = json[key];
    if (Array.isArray(value)) {
      attributes[key] = key === 'indices' ? new Uint16Array(value) : new Float32Array(value);
    } else {
      modelOptions[key] = value;
    }
  }

  return new Model(gl, Object.assign({ program: program, geometry: new Geometry({ attributes: attributes }) }, modelOptions, opts));
}

function parseJSON(file) {
  try {
    return JSON.parse(file);
  } catch (error) {
    throw new Error('Failed to parse JSON: ' + error);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy90ZXN0LXV0aWxzL2x1bWEuZ2wvaW8tYmFzaWMvanNvbi1sb2FkZXIuanMiXSwibmFtZXMiOlsibG9hZEZpbGUiLCJQcm9ncmFtIiwiTW9kZWwiLCJHZW9tZXRyeSIsImxvYWRNb2RlbCIsImdsIiwib3B0cyIsInRoZW4iLCJmaWxlIiwicGFyc2VNb2RlbCIsIk9iamVjdCIsImFzc2lnbiIsInByb2dyYW0iLCJqc29uIiwicGFyc2VKU09OIiwiYXR0cmlidXRlcyIsIm1vZGVsT3B0aW9ucyIsImtleSIsInZhbHVlIiwiQXJyYXkiLCJpc0FycmF5IiwiVWludDE2QXJyYXkiLCJGbG9hdDMyQXJyYXkiLCJnZW9tZXRyeSIsIkpTT04iLCJwYXJzZSIsImVycm9yIiwiRXJyb3IiXSwibWFwcGluZ3MiOiI7O0FBQUEsU0FBUUEsUUFBUixRQUF1QixxQkFBdkI7QUFDQSxTQUFRQyxPQUFSLFFBQXNCLFVBQXRCO0FBQ0EsU0FBUUMsS0FBUixRQUFvQixTQUFwQjtBQUNBLFNBQVFDLFFBQVIsUUFBdUIsYUFBdkI7O0FBRUE7QUFDQSxPQUFPLFNBQVNDLFNBQVQsQ0FBbUJDLEVBQW5CLEVBQWtDO0FBQUEsTUFBWEMsSUFBVyx1RUFBSixFQUFJOztBQUN2QyxTQUFPTixTQUFTTSxJQUFULEVBQWVDLElBQWYsQ0FBb0I7QUFBQTtBQUFBLFFBQUVDLElBQUY7O0FBQUEsV0FBWUMsV0FBV0osRUFBWCxFQUFlSyxPQUFPQyxNQUFQLENBQWMsRUFBQ0gsVUFBRCxFQUFkLEVBQXNCRixJQUF0QixDQUFmLENBQVo7QUFBQSxHQUFwQixDQUFQO0FBQ0Q7O0FBRUQsT0FBTyxTQUFTRyxVQUFULENBQW9CSixFQUFwQixFQUFtQztBQUFBLE1BQVhDLElBQVcsdUVBQUosRUFBSTtBQUFBLE1BQ2pDRSxJQURpQyxHQUNFRixJQURGLENBQ2pDRSxJQURpQztBQUFBLHNCQUNFRixJQURGLENBQzNCTSxPQUQyQjtBQUFBLE1BQzNCQSxPQUQyQixpQ0FDakIsSUFBSVgsT0FBSixDQUFZSSxFQUFaLENBRGlCOztBQUV4QyxNQUFNUSxPQUFPLE9BQU9MLElBQVAsS0FBZ0IsUUFBaEIsR0FBMkJNLFVBQVVOLElBQVYsQ0FBM0IsR0FBNkNBLElBQTFEO0FBQ0E7QUFDQTtBQUNBLE1BQU1PLGFBQWEsRUFBbkI7QUFDQSxNQUFNQyxlQUFlLEVBQXJCO0FBQ0EsT0FBSyxJQUFNQyxHQUFYLElBQWtCSixJQUFsQixFQUF3QjtBQUN0QixRQUFNSyxRQUFRTCxLQUFLSSxHQUFMLENBQWQ7QUFDQSxRQUFJRSxNQUFNQyxPQUFOLENBQWNGLEtBQWQsQ0FBSixFQUEwQjtBQUN4QkgsaUJBQVdFLEdBQVgsSUFBa0JBLFFBQVEsU0FBUixHQUFvQixJQUFJSSxXQUFKLENBQWdCSCxLQUFoQixDQUFwQixHQUE2QyxJQUFJSSxZQUFKLENBQWlCSixLQUFqQixDQUEvRDtBQUNELEtBRkQsTUFFTztBQUNMRixtQkFBYUMsR0FBYixJQUFvQkMsS0FBcEI7QUFDRDtBQUNGOztBQUVELFNBQU8sSUFBSWhCLEtBQUosQ0FDTEcsRUFESyxFQUVMSyxPQUFPQyxNQUFQLENBQWMsRUFBQ0MsZ0JBQUQsRUFBVVcsVUFBVSxJQUFJcEIsUUFBSixDQUFhLEVBQUNZLHNCQUFELEVBQWIsQ0FBcEIsRUFBZCxFQUErREMsWUFBL0QsRUFBNkVWLElBQTdFLENBRkssQ0FBUDtBQUlEOztBQUVELFNBQVNRLFNBQVQsQ0FBbUJOLElBQW5CLEVBQXlCO0FBQ3ZCLE1BQUk7QUFDRixXQUFPZ0IsS0FBS0MsS0FBTCxDQUFXakIsSUFBWCxDQUFQO0FBQ0QsR0FGRCxDQUVFLE9BQU9rQixLQUFQLEVBQWM7QUFDZCxVQUFNLElBQUlDLEtBQUosNEJBQW1DRCxLQUFuQyxDQUFOO0FBQ0Q7QUFDRiIsImZpbGUiOiJqc29uLWxvYWRlci5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7bG9hZEZpbGV9IGZyb20gJy4vYnJvd3Nlci1sb2FkLWZpbGUnO1xuaW1wb3J0IHtQcm9ncmFtfSBmcm9tICcuLi93ZWJnbCc7XG5pbXBvcnQge01vZGVsfSBmcm9tICcuLi9jb3JlJztcbmltcG9ydCB7R2VvbWV0cnl9IGZyb20gJy4uL2dlb21ldHJ5JztcblxuLy8gTG9hZHMgYSBzaW1wbGUgSlNPTiBmb3JtYXRcbmV4cG9ydCBmdW5jdGlvbiBsb2FkTW9kZWwoZ2wsIG9wdHMgPSB7fSkge1xuICByZXR1cm4gbG9hZEZpbGUob3B0cykudGhlbigoW2ZpbGVdKSA9PiBwYXJzZU1vZGVsKGdsLCBPYmplY3QuYXNzaWduKHtmaWxlfSwgb3B0cykpKTtcbn1cblxuZXhwb3J0IGZ1bmN0aW9uIHBhcnNlTW9kZWwoZ2wsIG9wdHMgPSB7fSkge1xuICBjb25zdCB7ZmlsZSwgcHJvZ3JhbSA9IG5ldyBQcm9ncmFtKGdsKX0gPSBvcHRzO1xuICBjb25zdCBqc29uID0gdHlwZW9mIGZpbGUgPT09ICdzdHJpbmcnID8gcGFyc2VKU09OKGZpbGUpIDogZmlsZTtcbiAgLy8gUmVtb3ZlIGFueSBhdHRyaWJ1dGVzIHNvIHRoYXQgd2UgY2FuIGNyZWF0ZSBhIGdlb21ldHJ5XG4gIC8vIFRPRE8gLSBjaGFuZ2UgZm9ybWF0IHRvIHB1dCB0aGVzZSBpbiBnZW9tZXRyeSBzdWIgb2JqZWN0P1xuICBjb25zdCBhdHRyaWJ1dGVzID0ge307XG4gIGNvbnN0IG1vZGVsT3B0aW9ucyA9IHt9O1xuICBmb3IgKGNvbnN0IGtleSBpbiBqc29uKSB7XG4gICAgY29uc3QgdmFsdWUgPSBqc29uW2tleV07XG4gICAgaWYgKEFycmF5LmlzQXJyYXkodmFsdWUpKSB7XG4gICAgICBhdHRyaWJ1dGVzW2tleV0gPSBrZXkgPT09ICdpbmRpY2VzJyA/IG5ldyBVaW50MTZBcnJheSh2YWx1ZSkgOiBuZXcgRmxvYXQzMkFycmF5KHZhbHVlKTtcbiAgICB9IGVsc2Uge1xuICAgICAgbW9kZWxPcHRpb25zW2tleV0gPSB2YWx1ZTtcbiAgICB9XG4gIH1cblxuICByZXR1cm4gbmV3IE1vZGVsKFxuICAgIGdsLFxuICAgIE9iamVjdC5hc3NpZ24oe3Byb2dyYW0sIGdlb21ldHJ5OiBuZXcgR2VvbWV0cnkoe2F0dHJpYnV0ZXN9KX0sIG1vZGVsT3B0aW9ucywgb3B0cylcbiAgKTtcbn1cblxuZnVuY3Rpb24gcGFyc2VKU09OKGZpbGUpIHtcbiAgdHJ5IHtcbiAgICByZXR1cm4gSlNPTi5wYXJzZShmaWxlKTtcbiAgfSBjYXRjaCAoZXJyb3IpIHtcbiAgICB0aHJvdyBuZXcgRXJyb3IoYEZhaWxlZCB0byBwYXJzZSBKU09OOiAke2Vycm9yfWApO1xuICB9XG59XG4iXX0=