var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

/**
 * Covert all numbers in a deep structure to a given precision, allowing
 * reliable float comparisons. Converts data in-place.
 * @param  {mixed} input      Input data
 * @param  {Number} [precision] Desired precision
 * @return {mixed}            Input data, with all numbers converted
 */
export function toLowPrecision(input) {
  var precision = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 11;

  /* eslint-disable guard-for-in */
  if (typeof input === 'number') {
    input = Number(input.toPrecision(precision));
  }
  if (Array.isArray(input)) {
    input = input.map(function (item) {
      return toLowPrecision(item, precision);
    });
  }
  if ((typeof input === 'undefined' ? 'undefined' : _typeof(input)) === 'object') {
    for (var key in input) {
      input[key] = toLowPrecision(input[key], precision);
    }
  }
  return input;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy90ZXN0LXV0aWxzL3NyYy9wcmVjaXNpb24uanMiXSwibmFtZXMiOlsidG9Mb3dQcmVjaXNpb24iLCJpbnB1dCIsInByZWNpc2lvbiIsIk51bWJlciIsInRvUHJlY2lzaW9uIiwiQXJyYXkiLCJpc0FycmF5IiwibWFwIiwiaXRlbSIsImtleSJdLCJtYXBwaW5ncyI6Ijs7QUFBQTs7Ozs7OztBQU9BLE9BQU8sU0FBU0EsY0FBVCxDQUF3QkMsS0FBeEIsRUFBK0M7QUFBQSxNQUFoQkMsU0FBZ0IsdUVBQUosRUFBSTs7QUFDcEQ7QUFDQSxNQUFJLE9BQU9ELEtBQVAsS0FBaUIsUUFBckIsRUFBK0I7QUFDN0JBLFlBQVFFLE9BQU9GLE1BQU1HLFdBQU4sQ0FBa0JGLFNBQWxCLENBQVAsQ0FBUjtBQUNEO0FBQ0QsTUFBSUcsTUFBTUMsT0FBTixDQUFjTCxLQUFkLENBQUosRUFBMEI7QUFDeEJBLFlBQVFBLE1BQU1NLEdBQU4sQ0FBVTtBQUFBLGFBQVFQLGVBQWVRLElBQWYsRUFBcUJOLFNBQXJCLENBQVI7QUFBQSxLQUFWLENBQVI7QUFDRDtBQUNELE1BQUksUUFBT0QsS0FBUCx5Q0FBT0EsS0FBUCxPQUFpQixRQUFyQixFQUErQjtBQUM3QixTQUFLLElBQU1RLEdBQVgsSUFBa0JSLEtBQWxCLEVBQXlCO0FBQ3ZCQSxZQUFNUSxHQUFOLElBQWFULGVBQWVDLE1BQU1RLEdBQU4sQ0FBZixFQUEyQlAsU0FBM0IsQ0FBYjtBQUNEO0FBQ0Y7QUFDRCxTQUFPRCxLQUFQO0FBQ0QiLCJmaWxlIjoicHJlY2lzaW9uLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBDb3ZlcnQgYWxsIG51bWJlcnMgaW4gYSBkZWVwIHN0cnVjdHVyZSB0byBhIGdpdmVuIHByZWNpc2lvbiwgYWxsb3dpbmdcbiAqIHJlbGlhYmxlIGZsb2F0IGNvbXBhcmlzb25zLiBDb252ZXJ0cyBkYXRhIGluLXBsYWNlLlxuICogQHBhcmFtICB7bWl4ZWR9IGlucHV0ICAgICAgSW5wdXQgZGF0YVxuICogQHBhcmFtICB7TnVtYmVyfSBbcHJlY2lzaW9uXSBEZXNpcmVkIHByZWNpc2lvblxuICogQHJldHVybiB7bWl4ZWR9ICAgICAgICAgICAgSW5wdXQgZGF0YSwgd2l0aCBhbGwgbnVtYmVycyBjb252ZXJ0ZWRcbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHRvTG93UHJlY2lzaW9uKGlucHV0LCBwcmVjaXNpb24gPSAxMSkge1xuICAvKiBlc2xpbnQtZGlzYWJsZSBndWFyZC1mb3ItaW4gKi9cbiAgaWYgKHR5cGVvZiBpbnB1dCA9PT0gJ251bWJlcicpIHtcbiAgICBpbnB1dCA9IE51bWJlcihpbnB1dC50b1ByZWNpc2lvbihwcmVjaXNpb24pKTtcbiAgfVxuICBpZiAoQXJyYXkuaXNBcnJheShpbnB1dCkpIHtcbiAgICBpbnB1dCA9IGlucHV0Lm1hcChpdGVtID0+IHRvTG93UHJlY2lzaW9uKGl0ZW0sIHByZWNpc2lvbikpO1xuICB9XG4gIGlmICh0eXBlb2YgaW5wdXQgPT09ICdvYmplY3QnKSB7XG4gICAgZm9yIChjb25zdCBrZXkgaW4gaW5wdXQpIHtcbiAgICAgIGlucHV0W2tleV0gPSB0b0xvd1ByZWNpc2lvbihpbnB1dFtrZXldLCBwcmVjaXNpb24pO1xuICAgIH1cbiAgfVxuICByZXR1cm4gaW5wdXQ7XG59XG4iXX0=