// Inspired by https://github.com/popomore/spy
// Attach a spy to the function. The spy has the following methods and fields
//  * restore() - remove spy completely
//  * reset() - reset call count
//  * callCount - number of calls
//  * called - whether spy was called
export default function makeSpy(obj, func) {
  var methodName = void 0;

  if (!obj && !func) {
    func = function mock() {};
    obj = {};
    methodName = 'spy';
  } else if (typeof obj === 'function' && !func) {
    func = obj;
    obj = {};
    methodName = func.name + '-spy';
  } else {
    methodName = func;
    func = obj[methodName];
  }

  // will not wrap more than once
  if (func.func !== undefined) {
    return func;
  }

  function spy() {
    spy.callCount++;
    spy.called = true;
    /* eslint-disable no-invalid-this */

    for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    return func.apply(this, args);
  }

  spy.reset = function () {
    spy.callCount = 0;
    spy.called = false;
  };

  spy.restore = function () {
    obj[methodName] = func;
  };

  spy.obj = obj;
  spy.methodName = methodName;
  spy.func = func;
  spy.method = func;

  spy.reset();

  obj[methodName] = spy;
  return spy;
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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