"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME arc-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec4 instanceSourceColors;\nattribute vec4 instanceTargetColors;\n\nattribute vec4 instancePositions;\nattribute vec4 instancePositions64Low;\n\nattribute vec3 instancePickingColors;\n\nuniform float numSegments;\nuniform float strokeWidth;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvec2 paraboloid_fp64(vec2 source[2], vec2 target[2], float ratio) {\n\n  vec2 x[2];\n  vec2_mix_fp64(source, target, ratio, x);\n  vec2 center[2];\n  vec2_mix_fp64(source, target, 0.5, center);\n\n  vec2 dSourceCenter = vec2_distance_fp64(source, center);\n  vec2 dXCenter = vec2_distance_fp64(x, center);\n  return mul_fp64(sum_fp64(dSourceCenter, dXCenter), sub_fp64(dSourceCenter, dXCenter));\n}\n\n// offset vector by strokeWidth pixels\n// offset_direction is -1 (left) or 1 (right)\nvec2 getExtrusionOffset(vec2 line_clipspace, float offset_direction) {\n  // normalized direction of the line\n  vec2 dir_screenspace = normalize(line_clipspace * project_uViewportSize);\n  // rotate by 90 degrees\n  dir_screenspace = vec2(-dir_screenspace.y, dir_screenspace.x);\n\n  vec2 offset_screenspace = dir_screenspace * offset_direction * strokeWidth / 2.0;\n  vec2 offset_clipspace = project_pixel_to_clipspace(offset_screenspace).xy;\n\n  return offset_clipspace;\n}\n\nfloat getSegmentRatio(float index) {\n  return smoothstep(0.0, 1.0, index / (numSegments - 1.0));\n}\n\nvoid get_pos_fp64(vec2 source[2], vec2 target[2], float segmentRatio, out vec2 position[4]) {\n\n  vec2 vertex_height = paraboloid_fp64(source, target, segmentRatio);\n\n  vec2 position_temp[2];\n\n  vec2_mix_fp64(source, target, segmentRatio, position_temp);\n\n  position[0] = position_temp[0];\n  position[1] = position_temp[1];\n\n  if (vertex_height.x < 0.0 || (vertex_height.x == 0.0 && vertex_height.y <= 0.0)) {\n    vertex_height = vec2(0.0, 0.0);\n  }\n\n  position[2] = sqrt_fp64(vertex_height);\n  position[3] = vec2(1.0, 0.0);\n}\n\nvoid main(void) {\n  vec4 instanceSourcePositions64 = vec4(instancePositions.x,\n    instancePositions64Low.x, instancePositions.y, instancePositions64Low.y);\n  vec4 instanceTargetPositions64 = vec4(instancePositions.z,\n    instancePositions64Low.z, instancePositions.w, instancePositions64Low.w);\n\n  vec2 projected_source_coord[2];\n  vec2 projected_target_coord[2];\n\n  project_position_fp64(instanceSourcePositions64, projected_source_coord);\n  project_position_fp64(instanceTargetPositions64, projected_target_coord);\n\n  float segmentIndex = positions.x;\n  float segmentRatio = getSegmentRatio(segmentIndex);\n\n  // if it's the first point, use next - current as direction\n  // otherwise use current - prev\n  float indexDir = mix(-1.0, 1.0, step(segmentIndex, 0.0));\n  float nextSegmentRatio = getSegmentRatio(segmentIndex + indexDir);\n\n  vec2 curr_pos_modelspace[4];\n\n  get_pos_fp64(projected_source_coord, projected_target_coord, segmentRatio,\n    curr_pos_modelspace);\n\n  vec2 next_pos_modelspace[4];\n\n  get_pos_fp64(projected_source_coord, projected_target_coord, nextSegmentRatio,\n    next_pos_modelspace);\n\n  vec4 curr_pos_clipspace = project_to_clipspace_fp64(curr_pos_modelspace);\n  vec4 next_pos_clipspace = project_to_clipspace_fp64(next_pos_modelspace);\n\n  vec2 offset = getExtrusionOffset(next_pos_clipspace.xy - curr_pos_clipspace.xy, positions.y);\n\n  gl_Position = curr_pos_clipspace + vec4(offset, 0.0, 0.0);\n\n  vec4 color = mix(instanceSourceColors, instanceTargetColors, segmentRatio) / 255.;\n  vColor = vec4(color.rgb, color.a * opacity);\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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