"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Inspired by screen-grid-layer vertex shader in deck.gl

exports.default = "#define SHADER_NAME grid-cell-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec3 normals;\n\nattribute vec4 instancePositions;\nattribute vec2 instancePositions64xyLow;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float extruded;\nuniform float cellSize;\nuniform float coverage;\nuniform float opacity;\nuniform float elevationScale;\n\n// A magic number to scale elevation so that 1 unit approximate to 1 meter\n#define ELEVATION_SCALE 0.8\n\n// Result\nvarying vec4 vColor;\n\nvoid main(void) {\n  vec4 instancePositions64xy = vec4(\n    instancePositions.x,\n    instancePositions64xyLow.x,\n    instancePositions.y,\n    instancePositions64xyLow.y);\n\n  vec2 projected_coord_xy[2];\n  project_position_fp64(instancePositions64xy, projected_coord_xy);\n\n  // if ahpha == 0.0 or z < 0.0, do not render element\n  float noRender = float(instanceColors.a == 0.0 || instancePositions.w < 0.0);\n  float finalCellSize = cellSize * mix(1.0, 0.0, noRender);\n\n  projected_coord_xy[0] = sum_fp64(projected_coord_xy[0],\n    vec2((positions.x * coverage + 1.0) * finalCellSize / 2.0, 0.0));\n  projected_coord_xy[1] = sum_fp64(projected_coord_xy[1],\n    vec2((positions.y * coverage - 1.0) * finalCellSize / 2.0, 0.0));\n\n  float elevation = 0.0;\n\n  if (extruded > 0.5) {\n    elevation = project_scale(instancePositions.w  * (positions.z + 1.0) *\n      ELEVATION_SCALE * elevationScale) + 1.0;\n  }\n\n  vec2 vertex_pos_modelspace[4];\n  vertex_pos_modelspace[0] = projected_coord_xy[0];\n  vertex_pos_modelspace[1] = projected_coord_xy[1];\n  vertex_pos_modelspace[2] = vec2(elevation, 0.0);\n  vertex_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 position_worldspace = vec4(\n    vertex_pos_modelspace[0].x, vertex_pos_modelspace[1].x,\n    vertex_pos_modelspace[2].x, vertex_pos_modelspace[3].x);\n\n  gl_Position = project_to_clipspace_fp64(vertex_pos_modelspace);\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    lightWeight = getLightWeight(\n      position_worldspace.xyz, // the w component is always 1.0\n      normals\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * instanceColors.rgb;\n  vec4 color = vec4(lightWeightedColor, instanceColors.a * opacity) / 255.0;\n  vColor = color;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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