"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Inspired by screen-grid-layer vertex shader in deck.gl

exports.default = "#define SHADER_NAME grid-cell-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 normals;\n\nattribute vec4 instancePositions;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float extruded;\nuniform float cellSize;\nuniform float coverage;\nuniform float opacity;\nuniform float elevationScale;\n\n// A magic number to scale elevation so that 1 unit approximate to 1 meter\n#define ELEVATION_SCALE 0.8\n\n// Result\nvarying vec4 vColor;\n\nvoid main(void) {\n\n  vec2 topLeftPos = project_position(instancePositions.xy);\n\n  // if ahpha == 0.0 or z < 0.0, do not render element\n  float noRender = float(instanceColors.a == 0.0 || instancePositions.w < 0.0);\n  float finalCellSize = cellSize * mix(1.0, 0.0, noRender);\n\n  // cube gemoetry vertics are between -1 to 1, scale and transform it to between 0, 1\n  vec2 pos = topLeftPos + vec2(\n  (positions.x * coverage + 1.0) / 2.0 * finalCellSize,\n  (positions.y * coverage - 1.0) / 2.0 * finalCellSize);\n\n  float elevation = 0.0;\n\n  if (extruded > 0.5) {\n    elevation = project_scale(instancePositions.w  * (positions.z + 1.0) *\n      ELEVATION_SCALE * elevationScale);\n  }\n\n  // extrude positions\n  vec3 extrudedPosition = vec3(pos.xy, elevation + 1.0);\n  vec4 position_worldspace = vec4(extrudedPosition, 1.0);\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    lightWeight = getLightWeight(\n      position_worldspace.xyz, // the w component is always 1.0\n      normals\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * instanceColors.rgb;\n  vec4 color = vec4(lightWeightedColor, instanceColors.a * opacity) / 255.0;\n  vColor = color;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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