"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME hexagon-cell-layer-vertex-shader-64\n\nattribute vec3 positions;\nattribute vec3 normals;\n\nattribute vec3 instancePositions;\nattribute vec2 instancePositions64xyLow;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Custom uniforms\nuniform float opacity;\nuniform float radius;\nuniform float angle;\nuniform float extruded;\nuniform float coverage;\nuniform float elevationScale;\n\n// Result\nvarying vec4 vColor;\n\n// A magic number to scale elevation so that 1 unit approximate to 1 meter.\n#define ELEVATION_SCALE 0.8\n\nvoid main(void) {\n\n  // rotate primitive position and normal\n  mat2 rotationMatrix = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));\n\n  vec2 rPos = rotationMatrix * positions.xz;\n  vec2 rNorm = rotationMatrix * normals.xz; // the hexagon cells has y axis as the vertical axis\n\n  vec3 rotatedPositions = vec3(rPos.x, positions.y, rPos.y);\n  vec3 rotatedNormals = vec3(rNorm.x, rNorm.y, normals.y);\n\n  // calculate elevation, if 3d not enabled set to 0\n  // cylindar gemoetry height are between -0.5 to 0.5, transform it to between 0, 1\n  float elevation = 0.0;\n\n  if (extruded > 0.5) {\n    elevation = project_scale(instancePositions.z * (positions.y + 0.5) *\n      ELEVATION_SCALE * elevationScale);\n  }\n\n  // if alpha == 0.0 or z < 0.0, do not render element\n  float noRender = float(instanceColors.a == 0.0 || instancePositions.z < 0.0);\n  float dotRadius = radius * mix(coverage, 0.0, noRender);\n\n  // project center of hexagon\n\n  vec4 instancePositions64xy = vec4(\n    instancePositions.x, instancePositions64xyLow.x,\n    instancePositions.y, instancePositions64xyLow.y);\n\n  vec2 projected_coord_xy[2];\n  project_position_fp64(instancePositions64xy, projected_coord_xy);\n\n  vec2 vertex_pos_localspace[4];\n  vec4_fp64(vec4(rotatedPositions.xz * dotRadius, 0.0, 1.0), vertex_pos_localspace);\n\n  vec2 vertex_pos_modelspace[4];\n  vertex_pos_modelspace[0] = sum_fp64(vertex_pos_localspace[0], projected_coord_xy[0]);\n  vertex_pos_modelspace[1] = sum_fp64(vertex_pos_localspace[1], projected_coord_xy[1]);\n  vertex_pos_modelspace[2] = sum_fp64(vertex_pos_localspace[2], vec2(elevation, 0.0));\n  vertex_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  vec4 position_worldspace = vec4(\n    vertex_pos_modelspace[0].x, vertex_pos_modelspace[1].x,\n    vertex_pos_modelspace[2].x, vertex_pos_modelspace[3].x);\n\n  gl_Position = project_to_clipspace_fp64(vertex_pos_modelspace);\n\n  // Light calculations\n  // Worldspace is the linear space after Mercator projection\n\n  vec3 normals_worldspace = rotatedNormals;\n\n  float lightWeight = 1.0;\n\n  if (extruded > 0.5) {\n    lightWeight = getLightWeight(\n      position_worldspace.xyz, // the w component is always 1.0\n      normals_worldspace\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * instanceColors.rgb;\n\n  // Color: Either opacity-multiplied instance color, or picking color\n  vColor = vec4(lightWeightedColor, opacity * instanceColors.a) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(instancePickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9jb3JlLWxheWVycy9oZXhhZ29uLWNlbGwtbGF5ZXIvaGV4YWdvbi1jZWxsLWxheWVyLXZlcnRleC02NC5nbHNsLmpzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0EiLCJmaWxlIjoiaGV4YWdvbi1jZWxsLWxheWVyLXZlcnRleC02NC5nbHNsLmpzIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSAyMDE1IC0gMjAxNyBVYmVyIFRlY2hub2xvZ2llcywgSW5jLlxuLy9cbi8vIFBlcm1pc3Npb24gaXMgaGVyZWJ5IGdyYW50ZWQsIGZyZWUgb2YgY2hhcmdlLCB0byBhbnkgcGVyc29uIG9idGFpbmluZyBhIGNvcHlcbi8vIG9mIHRoaXMgc29mdHdhcmUgYW5kIGFzc29jaWF0ZWQgZG9jdW1lbnRhdGlvbiBmaWxlcyAodGhlIFwiU29mdHdhcmVcIiksIHRvIGRlYWxcbi8vIGluIHRoZSBTb2Z0d2FyZSB3aXRob3V0IHJlc3RyaWN0aW9uLCBpbmNsdWRpbmcgd2l0aG91dCBsaW1pdGF0aW9uIHRoZSByaWdodHNcbi8vIHRvIHVzZSwgY29weSwgbW9kaWZ5LCBtZXJnZSwgcHVibGlzaCwgZGlzdHJpYnV0ZSwgc3VibGljZW5zZSwgYW5kL29yIHNlbGxcbi8vIGNvcGllcyBvZiB0aGUgU29mdHdhcmUsIGFuZCB0byBwZXJtaXQgcGVyc29ucyB0byB3aG9tIHRoZSBTb2Z0d2FyZSBpc1xuLy8gZnVybmlzaGVkIHRvIGRvIHNvLCBzdWJqZWN0IHRvIHRoZSBmb2xsb3dpbmcgY29uZGl0aW9uczpcbi8vXG4vLyBUaGUgYWJvdmUgY29weXJpZ2h0IG5vdGljZSBhbmQgdGhpcyBwZXJtaXNzaW9uIG5vdGljZSBzaGFsbCBiZSBpbmNsdWRlZCBpblxuLy8gYWxsIGNvcGllcyBvciBzdWJzdGFudGlhbCBwb3J0aW9ucyBvZiB0aGUgU29mdHdhcmUuXG4vL1xuLy8gVEhFIFNPRlRXQVJFIElTIFBST1ZJREVEIFwiQVMgSVNcIiwgV0lUSE9VVCBXQVJSQU5UWSBPRiBBTlkgS0lORCwgRVhQUkVTUyBPUlxuLy8gSU1QTElFRCwgSU5DTFVESU5HIEJVVCBOT1QgTElNSVRFRCBUTyBUSEUgV0FSUkFOVElFUyBPRiBNRVJDSEFOVEFCSUxJVFksXG4vLyBGSVRORVNTIEZPUiBBIFBBUlRJQ1VMQVIgUFVSUE9TRSBBTkQgTk9OSU5GUklOR0VNRU5ULiBJTiBOTyBFVkVOVCBTSEFMTCBUSEVcbi8vIEFVVEhPUlMgT1IgQ09QWVJJR0hUIEhPTERFUlMgQkUgTElBQkxFIEZPUiBBTlkgQ0xBSU0sIERBTUFHRVMgT1IgT1RIRVJcbi8vIExJQUJJTElUWSwgV0hFVEhFUiBJTiBBTiBBQ1RJT04gT0YgQ09OVFJBQ1QsIFRPUlQgT1IgT1RIRVJXSVNFLCBBUklTSU5HIEZST00sXG4vLyBPVVQgT0YgT1IgSU4gQ09OTkVDVElPTiBXSVRIIFRIRSBTT0ZUV0FSRSBPUiBUSEUgVVNFIE9SIE9USEVSIERFQUxJTkdTIElOXG4vLyBUSEUgU09GVFdBUkUuXG5cbmV4cG9ydCBkZWZhdWx0IGBcXFxuI2RlZmluZSBTSEFERVJfTkFNRSBoZXhhZ29uLWNlbGwtbGF5ZXItdmVydGV4LXNoYWRlci02NFxuXG5hdHRyaWJ1dGUgdmVjMyBwb3NpdGlvbnM7XG5hdHRyaWJ1dGUgdmVjMyBub3JtYWxzO1xuXG5hdHRyaWJ1dGUgdmVjMyBpbnN0YW5jZVBvc2l0aW9ucztcbmF0dHJpYnV0ZSB2ZWMyIGluc3RhbmNlUG9zaXRpb25zNjR4eUxvdztcbmF0dHJpYnV0ZSB2ZWM0IGluc3RhbmNlQ29sb3JzO1xuYXR0cmlidXRlIHZlYzMgaW5zdGFuY2VQaWNraW5nQ29sb3JzO1xuXG4vLyBDdXN0b20gdW5pZm9ybXNcbnVuaWZvcm0gZmxvYXQgb3BhY2l0eTtcbnVuaWZvcm0gZmxvYXQgcmFkaXVzO1xudW5pZm9ybSBmbG9hdCBhbmdsZTtcbnVuaWZvcm0gZmxvYXQgZXh0cnVkZWQ7XG51bmlmb3JtIGZsb2F0IGNvdmVyYWdlO1xudW5pZm9ybSBmbG9hdCBlbGV2YXRpb25TY2FsZTtcblxuLy8gUmVzdWx0XG52YXJ5aW5nIHZlYzQgdkNvbG9yO1xuXG4vLyBBIG1hZ2ljIG51bWJlciB0byBzY2FsZSBlbGV2YXRpb24gc28gdGhhdCAxIHVuaXQgYXBwcm94aW1hdGUgdG8gMSBtZXRlci5cbiNkZWZpbmUgRUxFVkFUSU9OX1NDQUxFIDAuOFxuXG52b2lkIG1haW4odm9pZCkge1xuXG4gIC8vIHJvdGF0ZSBwcmltaXRpdmUgcG9zaXRpb24gYW5kIG5vcm1hbFxuICBtYXQyIHJvdGF0aW9uTWF0cml4ID0gbWF0Mihjb3MoYW5nbGUpLCAtc2luKGFuZ2xlKSwgc2luKGFuZ2xlKSwgY29zKGFuZ2xlKSk7XG5cbiAgdmVjMiByUG9zID0gcm90YXRpb25NYXRyaXggKiBwb3NpdGlvbnMueHo7XG4gIHZlYzIgck5vcm0gPSByb3RhdGlvbk1hdHJpeCAqIG5vcm1hbHMueHo7IC8vIHRoZSBoZXhhZ29uIGNlbGxzIGhhcyB5IGF4aXMgYXMgdGhlIHZlcnRpY2FsIGF4aXNcblxuICB2ZWMzIHJvdGF0ZWRQb3NpdGlvbnMgPSB2ZWMzKHJQb3MueCwgcG9zaXRpb25zLnksIHJQb3MueSk7XG4gIHZlYzMgcm90YXRlZE5vcm1hbHMgPSB2ZWMzKHJOb3JtLngsIHJOb3JtLnksIG5vcm1hbHMueSk7XG5cbiAgLy8gY2FsY3VsYXRlIGVsZXZhdGlvbiwgaWYgM2Qgbm90IGVuYWJsZWQgc2V0IHRvIDBcbiAgLy8gY3lsaW5kYXIgZ2Vtb2V0cnkgaGVpZ2h0IGFyZSBiZXR3ZWVuIC0wLjUgdG8gMC41LCB0cmFuc2Zvcm0gaXQgdG8gYmV0d2VlbiAwLCAxXG4gIGZsb2F0IGVsZXZhdGlvbiA9IDAuMDtcblxuICBpZiAoZXh0cnVkZWQgPiAwLjUpIHtcbiAgICBlbGV2YXRpb24gPSBwcm9qZWN0X3NjYWxlKGluc3RhbmNlUG9zaXRpb25zLnogKiAocG9zaXRpb25zLnkgKyAwLjUpICpcbiAgICAgIEVMRVZBVElPTl9TQ0FMRSAqIGVsZXZhdGlvblNjYWxlKTtcbiAgfVxuXG4gIC8vIGlmIGFscGhhID09IDAuMCBvciB6IDwgMC4wLCBkbyBub3QgcmVuZGVyIGVsZW1lbnRcbiAgZmxvYXQgbm9SZW5kZXIgPSBmbG9hdChpbnN0YW5jZUNvbG9ycy5hID09IDAuMCB8fCBpbnN0YW5jZVBvc2l0aW9ucy56IDwgMC4wKTtcbiAgZmxvYXQgZG90UmFkaXVzID0gcmFkaXVzICogbWl4KGNvdmVyYWdlLCAwLjAsIG5vUmVuZGVyKTtcblxuICAvLyBwcm9qZWN0IGNlbnRlciBvZiBoZXhhZ29uXG5cbiAgdmVjNCBpbnN0YW5jZVBvc2l0aW9uczY0eHkgPSB2ZWM0KFxuICAgIGluc3RhbmNlUG9zaXRpb25zLngsIGluc3RhbmNlUG9zaXRpb25zNjR4eUxvdy54LFxuICAgIGluc3RhbmNlUG9zaXRpb25zLnksIGluc3RhbmNlUG9zaXRpb25zNjR4eUxvdy55KTtcblxuICB2ZWMyIHByb2plY3RlZF9jb29yZF94eVsyXTtcbiAgcHJvamVjdF9wb3NpdGlvbl9mcDY0KGluc3RhbmNlUG9zaXRpb25zNjR4eSwgcHJvamVjdGVkX2Nvb3JkX3h5KTtcblxuICB2ZWMyIHZlcnRleF9wb3NfbG9jYWxzcGFjZVs0XTtcbiAgdmVjNF9mcDY0KHZlYzQocm90YXRlZFBvc2l0aW9ucy54eiAqIGRvdFJhZGl1cywgMC4wLCAxLjApLCB2ZXJ0ZXhfcG9zX2xvY2Fsc3BhY2UpO1xuXG4gIHZlYzIgdmVydGV4X3Bvc19tb2RlbHNwYWNlWzRdO1xuICB2ZXJ0ZXhfcG9zX21vZGVsc3BhY2VbMF0gPSBzdW1fZnA2NCh2ZXJ0ZXhfcG9zX2xvY2Fsc3BhY2VbMF0sIHByb2plY3RlZF9jb29yZF94eVswXSk7XG4gIHZlcnRleF9wb3NfbW9kZWxzcGFjZVsxXSA9IHN1bV9mcDY0KHZlcnRleF9wb3NfbG9jYWxzcGFjZVsxXSwgcHJvamVjdGVkX2Nvb3JkX3h5WzFdKTtcbiAgdmVydGV4X3Bvc19tb2RlbHNwYWNlWzJdID0gc3VtX2ZwNjQodmVydGV4X3Bvc19sb2NhbHNwYWNlWzJdLCB2ZWMyKGVsZXZhdGlvbiwgMC4wKSk7XG4gIHZlcnRleF9wb3NfbW9kZWxzcGFjZVszXSA9IHZlYzIoMS4wLCAwLjApO1xuXG4gIHZlYzQgcG9zaXRpb25fd29ybGRzcGFjZSA9IHZlYzQoXG4gICAgdmVydGV4X3Bvc19tb2RlbHNwYWNlWzBdLngsIHZlcnRleF9wb3NfbW9kZWxzcGFjZVsxXS54LFxuICAgIHZlcnRleF9wb3NfbW9kZWxzcGFjZVsyXS54LCB2ZXJ0ZXhfcG9zX21vZGVsc3BhY2VbM10ueCk7XG5cbiAgZ2xfUG9zaXRpb24gPSBwcm9qZWN0X3RvX2NsaXBzcGFjZV9mcDY0KHZlcnRleF9wb3NfbW9kZWxzcGFjZSk7XG5cbiAgLy8gTGlnaHQgY2FsY3VsYXRpb25zXG4gIC8vIFdvcmxkc3BhY2UgaXMgdGhlIGxpbmVhciBzcGFjZSBhZnRlciBNZXJjYXRvciBwcm9qZWN0aW9uXG5cbiAgdmVjMyBub3JtYWxzX3dvcmxkc3BhY2UgPSByb3RhdGVkTm9ybWFscztcblxuICBmbG9hdCBsaWdodFdlaWdodCA9IDEuMDtcblxuICBpZiAoZXh0cnVkZWQgPiAwLjUpIHtcbiAgICBsaWdodFdlaWdodCA9IGdldExpZ2h0V2VpZ2h0KFxuICAgICAgcG9zaXRpb25fd29ybGRzcGFjZS54eXosIC8vIHRoZSB3IGNvbXBvbmVudCBpcyBhbHdheXMgMS4wXG4gICAgICBub3JtYWxzX3dvcmxkc3BhY2VcbiAgICApO1xuICB9XG5cbiAgdmVjMyBsaWdodFdlaWdodGVkQ29sb3IgPSBsaWdodFdlaWdodCAqIGluc3RhbmNlQ29sb3JzLnJnYjtcblxuICAvLyBDb2xvcjogRWl0aGVyIG9wYWNpdHktbXVsdGlwbGllZCBpbnN0YW5jZSBjb2xvciwgb3IgcGlja2luZyBjb2xvclxuICB2Q29sb3IgPSB2ZWM0KGxpZ2h0V2VpZ2h0ZWRDb2xvciwgb3BhY2l0eSAqIGluc3RhbmNlQ29sb3JzLmEpIC8gMjU1LjA7XG5cbiAgLy8gU2V0IGNvbG9yIHRvIGJlIHJlbmRlcmVkIHRvIHBpY2tpbmcgZmJvIChhbHNvIHVzZWQgdG8gY2hlY2sgZm9yIHNlbGVjdGlvbiBoaWdobGlnaHQpLlxuICBwaWNraW5nX3NldFBpY2tpbmdDb2xvcihpbnN0YW5jZVBpY2tpbmdDb2xvcnMpO1xufVxuYDtcbiJdfQ==