'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _core = require('../../core');

var _luma = require('luma.gl');

var _hexagonCellLayerVertex = require('./hexagon-cell-layer-vertex.glsl');

var _hexagonCellLayerVertex2 = _interopRequireDefault(_hexagonCellLayerVertex);

var _hexagonCellLayerVertex3 = require('./hexagon-cell-layer-vertex-64.glsl');

var _hexagonCellLayerVertex4 = _interopRequireDefault(_hexagonCellLayerVertex3);

var _hexagonCellLayerFragment = require('./hexagon-cell-layer-fragment.glsl');

var _hexagonCellLayerFragment2 = _interopRequireDefault(_hexagonCellLayerFragment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var log = _core.experimental.log,
    fp64LowPart = _core.experimental.fp64LowPart,
    enable64bitSupport = _core.experimental.enable64bitSupport;


var DEFAULT_COLOR = [255, 0, 255, 255];

var defaultProps = {
  hexagonVertices: null,
  radius: null,
  angle: null,
  coverage: 1,
  elevationScale: 1,
  extruded: true,
  fp64: false,

  getCentroid: function getCentroid(x) {
    return x.centroid;
  },
  getColor: function getColor(x) {
    return x.color;
  },
  getElevation: function getElevation(x) {
    return x.elevation;
  },

  lightSettings: {
    lightsPosition: [-122.45, 37.75, 8000, -122.0, 38.0, 5000],
    ambientRatio: 0.4,
    diffuseRatio: 0.6,
    specularRatio: 0.8,
    lightsStrength: [1.2, 0.0, 0.8, 0.0],
    numberOfLights: 2
  }
};

var HexagonCellLayer = function (_Layer) {
  _inherits(HexagonCellLayer, _Layer);

  function HexagonCellLayer(props) {
    _classCallCheck(this, HexagonCellLayer);

    var missingProps = false;
    if (!props.hexagonVertices && (!props.radius || !Number.isFinite(props.angle))) {
      log.once(0, 'HexagonCellLayer: Either hexagonVertices or radius and angle are ' + 'needed to calculate primitive hexagon.');
      missingProps = true;
    } else if (props.hexagonVertices && (!Array.isArray(props.hexagonVertices) || props.hexagonVertices.length < 6)) {
      log.once(0, 'HexagonCellLayer: hexagonVertices needs to be an array of 6 points');

      missingProps = true;
    }

    if (missingProps) {
      log.once(0, 'Now using 1000 meter as default radius, 0 as default angle');
      props.radius = 1000;
      props.angle = 0;
    }

    return _possibleConstructorReturn(this, (HexagonCellLayer.__proto__ || Object.getPrototypeOf(HexagonCellLayer)).call(this, props));
  }

  _createClass(HexagonCellLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: _hexagonCellLayerVertex4.default, fs: _hexagonCellLayerFragment2.default, modules: ['project64', 'lighting', 'picking'] } : { vs: _hexagonCellLayerVertex2.default, fs: _hexagonCellLayerFragment2.default, modules: ['lighting', 'picking'] }; // 'project' module added by default.
    }

    /**
     * DeckGL calls initializeState when GL context is available
     * Essentially a deferred constructor
     */

  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instancePositions: {
          size: 3,
          transition: true,
          accessor: ['getCentroid', 'getElevation'],
          update: this.calculateInstancePositions
        },
        instanceColors: {
          size: 4,
          type: _luma.GL.UNSIGNED_BYTE,
          transition: true,
          accessor: 'getColor',
          update: this.calculateInstanceColors
        }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === _core.COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instancePositions64xyLow: {
              size: 2,
              accessor: 'getCentroid',
              update: this.calculateInstancePositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instancePositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var props = _ref2.props,
          oldProps = _ref2.oldProps,
          changeFlags = _ref2.changeFlags;

      _get(HexagonCellLayer.prototype.__proto__ || Object.getPrototypeOf(HexagonCellLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });

      this.updateUniforms();
    }
  }, {
    key: 'updateRadiusAngle',
    value: function updateRadiusAngle() {
      var angle = void 0;
      var radius = void 0;
      var hexagonVertices = this.props.hexagonVertices;


      if (Array.isArray(hexagonVertices) && hexagonVertices.length >= 6) {
        // calculate angle and vertices from hexagonVertices if provided
        var vertices = this.props.hexagonVertices;

        var vertex0 = vertices[0];
        var vertex3 = vertices[3];

        // transform to space coordinates
        var spaceCoord0 = this.projectFlat(vertex0);
        var spaceCoord3 = this.projectFlat(vertex3);

        // distance between two close centroids
        var dx = spaceCoord0[0] - spaceCoord3[0];
        var dy = spaceCoord0[1] - spaceCoord3[1];
        var dxy = Math.sqrt(dx * dx + dy * dy);

        // Calculate angle that the perpendicular hexagon vertex axis is tilted
        angle = Math.acos(dx / dxy) * -Math.sign(dy) + Math.PI / 2;
        radius = dxy / 2;
      } else if (this.props.radius && Number.isFinite(this.props.angle)) {
        // if no hexagonVertices provided, try use radius & angle
        var viewport = this.context.viewport;
        // TODO - this should be a standard uniform in project package

        var _viewport$getDistance = viewport.getDistanceScales(),
            pixelsPerMeter = _viewport$getDistance.pixelsPerMeter;

        angle = this.props.angle;
        radius = this.props.radius * pixelsPerMeter[0];
      }

      return { angle: angle, radius: radius };
    }
  }, {
    key: 'getCylinderGeometry',
    value: function getCylinderGeometry(radius) {
      return new _luma.CylinderGeometry({
        radius: radius,
        topRadius: radius,
        bottomRadius: radius,
        topCap: true,
        bottomCap: true,
        height: 1,
        nradial: 6,
        nvertical: 1
      });
    }
  }, {
    key: 'updateUniforms',
    value: function updateUniforms() {
      var _props = this.props,
          opacity = _props.opacity,
          elevationScale = _props.elevationScale,
          extruded = _props.extruded,
          coverage = _props.coverage,
          lightSettings = _props.lightSettings;
      var model = this.state.model;


      model.setUniforms(Object.assign({}, {
        extruded: extruded,
        opacity: opacity,
        coverage: coverage,
        elevationScale: elevationScale
      }, lightSettings));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      return new _luma.Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: this.getCylinderGeometry(1),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;

      _get(HexagonCellLayer.prototype.__proto__ || Object.getPrototypeOf(HexagonCellLayer.prototype), 'draw', this).call(this, { uniforms: Object.assign(this.updateRadiusAngle(), uniforms) });
    }
  }, {
    key: 'calculateInstancePositions',
    value: function calculateInstancePositions(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getCentroid = _props2.getCentroid,
          getElevation = _props2.getElevation;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion = true;
      var _didIteratorError = false;
      var _iteratorError = undefined;

      try {
        for (var _iterator = data[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
          var object = _step.value;

          var _getCentroid = getCentroid(object),
              _getCentroid2 = _slicedToArray(_getCentroid, 2),
              lon = _getCentroid2[0],
              lat = _getCentroid2[1];

          var elevation = getElevation(object);
          value[i + 0] = lon;
          value[i + 1] = lat;
          value[i + 2] = elevation || 0;
          i += size;
        }
      } catch (err) {
        _didIteratorError = true;
        _iteratorError = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion && _iterator.return) {
            _iterator.return();
          }
        } finally {
          if (_didIteratorError) {
            throw _iteratorError;
          }
        }
      }
    }
  }, {
    key: 'calculateInstancePositions64xyLow',
    value: function calculateInstancePositions64xyLow(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getCentroid = _props3.getCentroid;
      var value = attribute.value;

      var i = 0;
      var _iteratorNormalCompletion2 = true;
      var _didIteratorError2 = false;
      var _iteratorError2 = undefined;

      try {
        for (var _iterator2 = data[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
          var object = _step2.value;

          var position = getCentroid(object);
          value[i++] = fp64LowPart(position[0]);
          value[i++] = fp64LowPart(position[1]);
        }
      } catch (err) {
        _didIteratorError2 = true;
        _iteratorError2 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion2 && _iterator2.return) {
            _iterator2.return();
          }
        } finally {
          if (_didIteratorError2) {
            throw _iteratorError2;
          }
        }
      }
    }
  }, {
    key: 'calculateInstanceColors',
    value: function calculateInstanceColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var value = attribute.value,
          size = attribute.size;

      var i = 0;
      var _iteratorNormalCompletion3 = true;
      var _didIteratorError3 = false;
      var _iteratorError3 = undefined;

      try {
        for (var _iterator3 = data[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
          var object = _step3.value;

          var color = getColor(object) || DEFAULT_COLOR;

          value[i + 0] = color[0];
          value[i + 1] = color[1];
          value[i + 2] = color[2];
          value[i + 3] = Number.isFinite(color[3]) ? color[3] : DEFAULT_COLOR[3];
          i += size;
        }
      } catch (err) {
        _didIteratorError3 = true;
        _iteratorError3 = err;
      } finally {
        try {
          if (!_iteratorNormalCompletion3 && _iterator3.return) {
            _iterator3.return();
          }
        } finally {
          if (_didIteratorError3) {
            throw _iteratorError3;
          }
        }
      }
    }
  }]);

  return HexagonCellLayer;
}(_core.Layer);

exports.default = HexagonCellLayer;


HexagonCellLayer.layerName = 'HexagonCellLayer';
HexagonCellLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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