'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _get = function get(object, property, receiver) { if (object === null) object = Function.prototype; var desc = Object.getOwnPropertyDescriptor(object, property); if (desc === undefined) { var parent = Object.getPrototypeOf(object); if (parent === null) { return undefined; } else { return get(parent, property, receiver); } } else if ("value" in desc) { return desc.value; } else { var getter = desc.get; if (getter === undefined) { return undefined; } return getter.call(receiver); } };

var _core = require('../../core');

var _luma = require('luma.gl');

var _pathLayerVertex = require('./path-layer-vertex.glsl');

var _pathLayerVertex2 = _interopRequireDefault(_pathLayerVertex);

var _pathLayerVertex3 = require('./path-layer-vertex-64.glsl');

var _pathLayerVertex4 = _interopRequireDefault(_pathLayerVertex3);

var _pathLayerFragment = require('./path-layer-fragment.glsl');

var _pathLayerFragment2 = _interopRequireDefault(_pathLayerFragment);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var fp64LowPart = _core.experimental.fp64LowPart,
    enable64bitSupport = _core.experimental.enable64bitSupport;


var DEFAULT_COLOR = [0, 0, 0, 255];

var defaultProps = {
  widthScale: 1, // stroke width in meters
  widthMinPixels: 0, //  min stroke width in pixels
  widthMaxPixels: Number.MAX_SAFE_INTEGER, // max stroke width in pixels
  rounded: false,
  miterLimit: 4,
  fp64: false,
  dashJustified: false,

  getPath: function getPath(object) {
    return object.path;
  },
  getColor: function getColor(object) {
    return object.color || DEFAULT_COLOR;
  },
  getWidth: function getWidth(object) {
    return object.width || 1;
  },
  getDashArray: null
};

var isClosed = function isClosed(path) {
  var firstPoint = path[0];
  var lastPoint = path[path.length - 1];
  return firstPoint[0] === lastPoint[0] && firstPoint[1] === lastPoint[1] && firstPoint[2] === lastPoint[2];
};

var PathLayer = function (_Layer) {
  _inherits(PathLayer, _Layer);

  function PathLayer() {
    _classCallCheck(this, PathLayer);

    return _possibleConstructorReturn(this, (PathLayer.__proto__ || Object.getPrototypeOf(PathLayer)).apply(this, arguments));
  }

  _createClass(PathLayer, [{
    key: 'getShaders',
    value: function getShaders() {
      return enable64bitSupport(this.props) ? { vs: _pathLayerVertex4.default, fs: _pathLayerFragment2.default, modules: ['project64', 'picking'] } : { vs: _pathLayerVertex2.default, fs: _pathLayerFragment2.default, modules: ['picking'] }; // 'project' module added by default.
    }
  }, {
    key: 'initializeState',
    value: function initializeState() {
      var attributeManager = this.getAttributeManager();
      /* eslint-disable max-len */
      attributeManager.addInstanced({
        instanceStartPositions: { size: 3, update: this.calculateStartPositions },
        instanceEndPositions: { size: 3, update: this.calculateEndPositions },
        instanceLeftDeltas: { size: 3, update: this.calculateLeftDeltas },
        instanceRightDeltas: { size: 3, update: this.calculateRightDeltas },
        instanceStrokeWidths: { size: 1, accessor: 'getWidth', update: this.calculateStrokeWidths },
        instanceDashArrays: { size: 2, accessor: 'getDashArray', update: this.calculateDashArrays },
        instanceColors: {
          size: 4,
          type: _luma.GL.UNSIGNED_BYTE,
          accessor: 'getColor',
          update: this.calculateColors
        },
        instancePickingColors: { size: 3, type: _luma.GL.UNSIGNED_BYTE, update: this.calculatePickingColors }
      });
      /* eslint-enable max-len */
    }
  }, {
    key: 'updateAttribute',
    value: function updateAttribute(_ref) {
      var props = _ref.props,
          oldProps = _ref.oldProps,
          changeFlags = _ref.changeFlags;

      if (props.fp64 !== oldProps.fp64) {
        var attributeManager = this.getAttributeManager();
        attributeManager.invalidateAll();

        if (props.fp64 && props.coordinateSystem === _core.COORDINATE_SYSTEM.LNGLAT) {
          attributeManager.addInstanced({
            instanceStartEndPositions64xyLow: {
              size: 4,
              update: this.calculateInstanceStartEndPositions64xyLow
            }
          });
        } else {
          attributeManager.remove(['instanceStartEndPositions64xyLow']);
        }
      }
    }
  }, {
    key: 'updateState',
    value: function updateState(_ref2) {
      var oldProps = _ref2.oldProps,
          props = _ref2.props,
          changeFlags = _ref2.changeFlags;

      _get(PathLayer.prototype.__proto__ || Object.getPrototypeOf(PathLayer.prototype), 'updateState', this).call(this, { props: props, oldProps: oldProps, changeFlags: changeFlags });

      var getPath = this.props.getPath;

      var attributeManager = this.getAttributeManager();
      if (props.fp64 !== oldProps.fp64) {
        var gl = this.context.gl;

        if (this.state.model) {
          this.state.model.delete();
        }
        this.setState({ model: this._getModel(gl) });
      }
      this.updateAttribute({ props: props, oldProps: oldProps, changeFlags: changeFlags });

      var geometryChanged = changeFlags.dataChanged || changeFlags.updateTriggersChanged && (changeFlags.updateTriggersChanged.all || changeFlags.updateTriggersChanged.getPath);

      if (geometryChanged) {
        // this.state.paths only stores point positions in each path
        var paths = props.data.map(getPath);
        var numInstances = paths.reduce(function (count, path) {
          return count + path.length - 1;
        }, 0);

        this.setState({ paths: paths, numInstances: numInstances });
        attributeManager.invalidateAll();
      }
    }
  }, {
    key: 'draw',
    value: function draw(_ref3) {
      var uniforms = _ref3.uniforms;
      var _props = this.props,
          rounded = _props.rounded,
          miterLimit = _props.miterLimit,
          widthScale = _props.widthScale,
          widthMinPixels = _props.widthMinPixels,
          widthMaxPixels = _props.widthMaxPixels,
          dashJustified = _props.dashJustified;


      this.state.model.render(Object.assign({}, uniforms, {
        jointType: Number(rounded),
        alignMode: Number(dashJustified),
        widthScale: widthScale,
        miterLimit: miterLimit,
        widthMinPixels: widthMinPixels,
        widthMaxPixels: widthMaxPixels
      }));
    }
  }, {
    key: '_getModel',
    value: function _getModel(gl) {
      /*
       *       _
       *        "-_ 1                   3                       5
       *     _     "o---------------------o-------------------_-o
       *       -   / ""--..__              '.             _.-' /
       *   _     "@- - - - - ""--..__- - - - x - - - -_.@'    /
       *    "-_  /                   ""--..__ '.  _,-` :     /
       *       "o----------------------------""-o'    :     /
       *      0,2                            4 / '.  :     /
       *                                      /   '.:     /
       *                                     /     :'.   /
       *                                    /     :  ', /
       *                                   /     :     o
       */

      var SEGMENT_INDICES = [
      // start corner
      0, 2, 1,
      // body
      1, 2, 4, 1, 4, 3,
      // end corner
      3, 4, 5];

      // [0] position on segment - 0: start, 1: end
      // [1] side of path - -1: left, 0: center, 1: right
      // [2] role - 0: offset point 1: joint point
      var SEGMENT_POSITIONS = [
      // bevel start corner
      0, 0, 1,
      // start inner corner
      0, -1, 0,
      // start outer corner
      0, 1, 0,
      // end inner corner
      1, -1, 0,
      // end outer corner
      1, 1, 0,
      // bevel end corner
      1, 0, 1];

      return new _luma.Model(gl, Object.assign({}, this.getShaders(), {
        id: this.props.id,
        geometry: new _luma.Geometry({
          drawMode: _luma.GL.TRIANGLES,
          attributes: {
            indices: new Uint16Array(SEGMENT_INDICES),
            positions: new Float32Array(SEGMENT_POSITIONS)
          }
        }),
        isInstanced: true,
        shaderCache: this.context.shaderCache
      }));
    }
  }, {
    key: 'calculateStartPositions',
    value: function calculateStartPositions(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        var numSegments = path.length - 1;
        for (var ptIndex = 0; ptIndex < numSegments; ptIndex++) {
          var point = path[ptIndex];
          value[i++] = point[0];
          value[i++] = point[1];
          value[i++] = point[2] || 0;
        }
      });
    }
  }, {
    key: 'calculateEndPositions',
    value: function calculateEndPositions(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          var point = path[ptIndex];
          value[i++] = point[0];
          value[i++] = point[1];
          value[i++] = point[2] || 0;
        }
      });
    }
  }, {
    key: 'calculateInstanceStartEndPositions64xyLow',
    value: function calculateInstanceStartEndPositions64xyLow(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        var numSegments = path.length - 1;
        for (var ptIndex = 0; ptIndex < numSegments; ptIndex++) {
          var startPoint = path[ptIndex];
          var endPoint = path[ptIndex + 1];
          value[i++] = fp64LowPart(startPoint[0]);
          value[i++] = fp64LowPart(startPoint[1]);
          value[i++] = fp64LowPart(endPoint[0]);
          value[i++] = fp64LowPart(endPoint[1]);
        }
      });
    }
  }, {
    key: 'calculateLeftDeltas',
    value: function calculateLeftDeltas(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        var numSegments = path.length - 1;
        var prevPoint = isClosed(path) ? path[path.length - 2] : path[0];

        for (var ptIndex = 0; ptIndex < numSegments; ptIndex++) {
          var point = path[ptIndex];
          value[i++] = point[0] - prevPoint[0];
          value[i++] = point[1] - prevPoint[1];
          value[i++] = point[2] - prevPoint[2] || 0;
          prevPoint = point;
        }
      });
    }
  }, {
    key: 'calculateRightDeltas',
    value: function calculateRightDeltas(attribute) {
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path) {
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          var point = path[ptIndex];
          var nextPoint = path[ptIndex + 1];
          if (!nextPoint) {
            nextPoint = isClosed(path) ? path[1] : point;
          }

          value[i++] = nextPoint[0] - point[0];
          value[i++] = nextPoint[1] - point[1];
          value[i++] = nextPoint[2] - point[2] || 0;
        }
      });
    }
  }, {
    key: 'calculateStrokeWidths',
    value: function calculateStrokeWidths(attribute) {
      var _props2 = this.props,
          data = _props2.data,
          getWidth = _props2.getWidth;
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path, index) {
        var width = getWidth(data[index], index);
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = width;
        }
      });
    }
  }, {
    key: 'calculateDashArrays',
    value: function calculateDashArrays(attribute) {
      var _props3 = this.props,
          data = _props3.data,
          getDashArray = _props3.getDashArray;

      if (!getDashArray) {
        return;
      }

      var paths = this.state.paths;
      var value = attribute.value;

      var i = 0;
      paths.forEach(function (path, index) {
        var dashArray = getDashArray(data[index], index);
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = dashArray[0];
          value[i++] = dashArray[1];
        }
      });
    }
  }, {
    key: 'calculateColors',
    value: function calculateColors(attribute) {
      var _props4 = this.props,
          data = _props4.data,
          getColor = _props4.getColor;
      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path, index) {
        var pointColor = getColor(data[index], index);
        if (isNaN(pointColor[3])) {
          pointColor[3] = 255;
        }
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = pointColor[0];
          value[i++] = pointColor[1];
          value[i++] = pointColor[2];
          value[i++] = pointColor[3];
        }
      });
    }

    // Override the default picking colors calculation

  }, {
    key: 'calculatePickingColors',
    value: function calculatePickingColors(attribute) {
      var _this2 = this;

      var paths = this.state.paths;
      var value = attribute.value;


      var i = 0;
      paths.forEach(function (path, index) {
        var pickingColor = _this2.encodePickingColor(index);
        for (var ptIndex = 1; ptIndex < path.length; ptIndex++) {
          value[i++] = pickingColor[0];
          value[i++] = pickingColor[1];
          value[i++] = pickingColor[2];
        }
      });
    }
  }]);

  return PathLayer;
}(_core.Layer);

exports.default = PathLayer;


PathLayer.layerName = 'PathLayer';
PathLayer.defaultProps = defaultProps;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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