"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME solid-polygon-layer-vertex-shader\n\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec4 colors;\nattribute vec3 pickingColors;\n\nuniform float extruded;\nuniform float elevationScale;\nuniform float opacity;\n\nvarying vec4 vColor;\n\nvoid main(void) {\n  \n  vec4 position_worldspace = vec4(project_position(\n    vec3(positions.x, positions.y, positions.z * elevationScale)),\n    1.0\n  );\n  gl_Position = project_to_clipspace(position_worldspace);\n\n  float lightWeight = 1.0;\n  \n  if (extruded > 0.5) {\n    // Here, the input parameters should be\n    // position_worldspace.xyz / position_worldspace.w.\n    // However, this calculation generates all zeros on\n    // MacBook Pro with Intel Iris Pro GPUs for unclear reasons.\n    // (see https://github.com/uber/deck.gl/issues/559)\n    // Since the w component is always 1.0 in our shaders,\n    // we decided to just provide xyz component of position_worldspace\n    // to the getLightWeight() function\n    lightWeight = getLightWeight(\n      position_worldspace.xyz,\n      project_normal(normals)\n    );\n  }\n\n  vec3 lightWeightedColor = lightWeight * colors.rgb;\n  vColor = vec4(lightWeightedColor, colors.a * opacity) / 255.0;\n\n  // Set color to be rendered to picking fbo (also used to check for selection highlight).\n  picking_setPickingColor(pickingColors);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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