'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Note: The numeric values here are matched by shader code in the
// "project" and "project64" shader modules. Both places need to be
// updated.

// TODO: Maybe "POSITIONS" would be a better name?
var COORDINATE_SYSTEM = exports.COORDINATE_SYSTEM = {
  // Positions are interpreted as [lng, lat, elevation]
  // lng lat are degrees, elevation is meters. distances as meters.
  LNGLAT: 1.0,

  // Positions are interpreted as meter offsets, distances as meters
  // Planned to deprecate in later versions
  METER_OFFSETS: 2.0,
  METERS: 2.0,

  // Positions are interpreted as lng lat offsets: [deltaLng, deltaLat, elevation]
  // deltaLng, deltaLat are delta degrees, elevation is meters.
  // distances as meters.
  LNGLAT_OFFSETS: 3.0,

  // Positions and distances are not transformed: [x, y, z] in unit coordinates
  IDENTITY: 0.0
};

var LIFECYCLE = exports.LIFECYCLE = {
  NO_STATE: 'Awaiting state',
  MATCHED: 'Matched. State transferred from previous layer',
  INITIALIZED: 'Intialized',
  AWAITING_GC: 'Discarded. Awaiting garbage collection',
  AWAITING_FINALIZATION: 'No longer matched. Awaiting garbage collection',
  FINALIZED: 'Finalized! Awaiting garbage collection'
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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