'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _luma = require('luma.gl');

var _project = require('../project/project');

var _project2 = _interopRequireDefault(_project);

var _fp = require('../../utils/fp64');

var _memoize = require('../../utils/memoize');

var _memoize2 = _interopRequireDefault(_memoize);

var _project3 = require('./project64.glsl');

var _project4 = _interopRequireDefault(_project3);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

exports.default = {
  name: 'project64',
  dependencies: [_project2.default, _luma.fp64],
  vs: _project4.default,
  getUniforms: getUniforms,
  deprecations: [{ type: 'uniform vec2', old: 'projectionFP64[16]', new: 'project_uViewProjectionMatrixFP64' }, { type: 'uniform vec2', old: 'projectionScaleFP64', new: 'project64_uScale' }]
};

// TODO - this module should calculate the 64 bit uniforms
// It is currently done by project to minimize duplicated work

// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

var DEFAULT_MODULE_OPTIONS = {};
var getMemoizedUniforms = (0, _memoize2.default)(calculateUniforms);

function getUniforms() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : DEFAULT_MODULE_OPTIONS;
  var context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  // These two uniforms are generated by the fp32 project module
  var project_uViewProjectionMatrix = context.project_uViewProjectionMatrix,
      project_uScale = context.project_uScale;


  if (project_uViewProjectionMatrix && project_uScale) {
    // We only need to update fp64 uniforms if fp32 projection is being updated
    return getMemoizedUniforms({ project_uViewProjectionMatrix: project_uViewProjectionMatrix, project_uScale: project_uScale });
  }
  return {};
}

function calculateUniforms(_ref) {
  var project_uViewProjectionMatrix = _ref.project_uViewProjectionMatrix,
      project_uScale = _ref.project_uScale;

  var glViewProjectionMatrixFP64 = (0, _fp.fp64ifyMatrix4)(project_uViewProjectionMatrix);
  var scaleFP64 = (0, _fp.fp64ify)(project_uScale);

  return {
    project_uViewProjectionMatrixFP64: glViewProjectionMatrixFP64,
    project64_uViewProjectionMatrix: glViewProjectionMatrixFP64,
    project64_uScale: scaleFP64
  };
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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