'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// Parse array or string color
function parseColor(color, target) {
  var index = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

  if (Array.isArray(color) || ArrayBuffer.isView(color)) {
    if (!target && color.length === 4) {
      return color;
    }

    target = target || [];
    target[index + 0] = color[0];
    target[index + 1] = color[1];
    target[index + 2] = color[2];
    target[index + 3] = color.length === 4 ? color[4] : 255;
    return target;
  }

  if (typeof color === 'string') {
    target = target || [];
    parseHexColor(color, target, index);
    return target;
  }

  return [0, 0, 0, 255];
}

// Parse a hex color
function parseHexColor(color, target, index) {
  if (color.length === 7) {
    var value = parseInt(color.substring(1), 16);
    target[index + 0] = Math.floor(value / 65536);
    target[index + 1] = Math.floor(value / 256 % 256);
    target[index + 2] = value % 256;
    target[index + 3] = 255;
  } else if (color.length === 9) {
    var _value = parseInt(color.substring(1), 16);
    target[index + 0] = Math.floor(_value / 16777216);
    target[index + 1] = Math.floor(_value / 65536 % 256);
    target[index + 2] = Math.floor(_value / 256 % 256);
    target[index + 3] = _value % 256;
  }
  return index + 4;
}

function setOpacity(color) {
  var opacity = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 127;

  return [color[0], color[1], color[2], opacity];
}

function applyOpacity(color) {
  var opacity = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 127;

  return [color[0], color[1], color[2], opacity];
}

// Named exports have a small perf hit in webpack, normally OK
// but for utils that will be called in tight inner loops, export as object
exports.default = { parseColor: parseColor, setOpacity: setOpacity, applyOpacity: applyOpacity };
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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