"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME mesh-layer-vs-64\n\n// Scale the model\nuniform float sizeScale;\n\n// Primitive attributes\nattribute vec3 positions;\nattribute vec3 normals;\nattribute vec2 texCoords;\n\n// Instance attributes\nattribute vec3 instancePositions;\nattribute vec2 instancePositions64xy;\nattribute float instanceAngles;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\n\n// Outputs to fragment shader\nvarying vec4 vColor;\nvarying vec2 vTexCoord;\nvarying float vLightWeight;\n\nvoid main(void) {\n  // Calculate arrow offset (from instance position)\n  float angle = instanceAngles;\n  mat2 rotationMatrix = mat2(cos(angle), -sin(angle), sin(angle), cos(angle));\n\n  vec3 offset = positions;\n  offset = project_scale(offset * sizeScale);\n  offset = vec3(rotationMatrix * offset.xy, offset.z);\n\n  gl_Position = project_position_and_offset_to_clipspace_fp64(\n    instancePositions, instancePositions64xy, offset\n  );\n\n  picking_setPickingColor(instancePickingColors);\n\n  vTexCoord = texCoords;\n  vColor = instanceColors;\n\n  //   lightWeight = getLightWeight(\n  //     position_worldspace.xyz, // the w component is always 1.0\n  //     normals\n  //   );\n  // vLightWeight = getLightWeight(pos, normals);\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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