"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
// Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

exports.default = "#define SHADER_NAME multi-icon-layer-vertex-shader-64\n\nattribute vec2 positions;\n\nattribute vec3 instancePositions;\nattribute vec2 instancePositions64xyLow;\nattribute float instanceSizes;\nattribute float instanceAngles;\nattribute vec4 instanceColors;\nattribute vec3 instancePickingColors;\nattribute vec4 instanceIconFrames;\nattribute float instanceColorModes;\nattribute vec2 instanceOffsets;\n\n// the following three attributes are for the multi-icon layer\nattribute float instanceIndexOfIcon;\nattribute float instanceNumOfIcon;\nattribute vec2 instancePixelOffset;\n\nuniform float sizeScale;\nuniform vec2 iconsTextureDim;\n\nvarying float vColorMode;\nvarying vec4 vColor;\nvarying vec2 vTextureCoords;\n\nvec2 rotate_by_angle(vec2 vertex, float angle) {\n  float angle_radian = angle * PI / 180.0;\n  float cos_angle = cos(angle_radian);\n  float sin_angle = sin(angle_radian);\n  mat2 rotationMatrix = mat2(cos_angle, -sin_angle, sin_angle, cos_angle);\n  return rotationMatrix * vertex;\n}\n\nvec2 getShift(float instanceIndexOfIcon, float instanceNumOfIcon) {\n  // calculate the middle index of the string\n  float midIndex = (instanceNumOfIcon - 1.0) / 2.0;\n  // calculate horizontal shift of each letter\n  return vec2(instanceIndexOfIcon - midIndex, 0.0);\n}\n\nvoid main(void) {\n  vec2 iconSize = instanceIconFrames.zw;\n  // scale icon height to match instanceSize\n  float instanceScale = iconSize.y == 0.0 ? 0.0 : instanceSizes / iconSize.y;\n\n  // scale and rotate vertex in \"pixel\" value and convert back to fraction in clipspace\n  vec2 shift = getShift(instanceIndexOfIcon, instanceNumOfIcon);\n  vec2 pixelOffset = (positions / 2.0 + shift) * iconSize + instanceOffsets;\n\n  pixelOffset = rotate_by_angle(pixelOffset, instanceAngles) * sizeScale * instanceScale;\n  pixelOffset += instancePixelOffset;\n  pixelOffset.y *= -1.0;\n\n  vec4 instancePositions64xy = vec4(\n  instancePositions.x, instancePositions64xyLow.x,\n  instancePositions.y, instancePositions64xyLow.y);\n\n  vec2 projected_coord_xy[2];\n  project_position_fp64(instancePositions64xy, projected_coord_xy);\n\n  vec2 vertex_pos_modelspace[4];\n  vertex_pos_modelspace[0] = projected_coord_xy[0];\n  vertex_pos_modelspace[1] = projected_coord_xy[1];\n  vertex_pos_modelspace[2] = vec2(project_scale(instancePositions.z), 0.0);\n  vertex_pos_modelspace[3] = vec2(1.0, 0.0);\n\n  gl_Position = project_to_clipspace_fp64(vertex_pos_modelspace);\n  gl_Position += project_pixel_to_clipspace(pixelOffset);\n\n  vTextureCoords = mix(\n    instanceIconFrames.xy,\n    instanceIconFrames.xy + iconSize,\n    (positions.xy + 1.0) / 2.0\n  ) / iconsTextureDim;\n\n  vTextureCoords.y = 1.0 - vTextureCoords.y;\n\n  vColor = instanceColors / 255.;\n  picking_setPickingColor(instancePickingColors);\n\n  vColorMode = instanceColorModes;\n}\n";
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uLy4uL3NyYy9leHBlcmltZW50YWwtbGF5ZXJzL3NyYy90ZXh0LWxheWVyL211bHRpLWljb24tbGF5ZXIvbXVsdGktaWNvbi1sYXllci12ZXJ0ZXgtNjQuZ2xzbC5qcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBO0FBQ0E7QUFDQTtBQUNBIiwiZmlsZSI6Im11bHRpLWljb24tbGF5ZXItdmVydGV4LTY0Lmdsc2wuanMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIDIwMTUgLSAyMDE3IFViZXIgVGVjaG5vbG9naWVzLCBJbmMuXG4vL1xuLy8gUGVybWlzc2lvbiBpcyBoZXJlYnkgZ3JhbnRlZCwgZnJlZSBvZiBjaGFyZ2UsIHRvIGFueSBwZXJzb24gb2J0YWluaW5nIGEgY29weVxuLy8gb2YgdGhpcyBzb2Z0d2FyZSBhbmQgYXNzb2NpYXRlZCBkb2N1bWVudGF0aW9uIGZpbGVzICh0aGUgXCJTb2Z0d2FyZVwiKSwgdG8gZGVhbFxuLy8gaW4gdGhlIFNvZnR3YXJlIHdpdGhvdXQgcmVzdHJpY3Rpb24sIGluY2x1ZGluZyB3aXRob3V0IGxpbWl0YXRpb24gdGhlIHJpZ2h0c1xuLy8gdG8gdXNlLCBjb3B5LCBtb2RpZnksIG1lcmdlLCBwdWJsaXNoLCBkaXN0cmlidXRlLCBzdWJsaWNlbnNlLCBhbmQvb3Igc2VsbFxuLy8gY29waWVzIG9mIHRoZSBTb2Z0d2FyZSwgYW5kIHRvIHBlcm1pdCBwZXJzb25zIHRvIHdob20gdGhlIFNvZnR3YXJlIGlzXG4vLyBmdXJuaXNoZWQgdG8gZG8gc28sIHN1YmplY3QgdG8gdGhlIGZvbGxvd2luZyBjb25kaXRpb25zOlxuLy9cbi8vIFRoZSBhYm92ZSBjb3B5cmlnaHQgbm90aWNlIGFuZCB0aGlzIHBlcm1pc3Npb24gbm90aWNlIHNoYWxsIGJlIGluY2x1ZGVkIGluXG4vLyBhbGwgY29waWVzIG9yIHN1YnN0YW50aWFsIHBvcnRpb25zIG9mIHRoZSBTb2Z0d2FyZS5cbi8vXG4vLyBUSEUgU09GVFdBUkUgSVMgUFJPVklERUQgXCJBUyBJU1wiLCBXSVRIT1VUIFdBUlJBTlRZIE9GIEFOWSBLSU5ELCBFWFBSRVNTIE9SXG4vLyBJTVBMSUVELCBJTkNMVURJTkcgQlVUIE5PVCBMSU1JVEVEIFRPIFRIRSBXQVJSQU5USUVTIE9GIE1FUkNIQU5UQUJJTElUWSxcbi8vIEZJVE5FU1MgRk9SIEEgUEFSVElDVUxBUiBQVVJQT1NFIEFORCBOT05JTkZSSU5HRU1FTlQuIElOIE5PIEVWRU5UIFNIQUxMIFRIRVxuLy8gQVVUSE9SUyBPUiBDT1BZUklHSFQgSE9MREVSUyBCRSBMSUFCTEUgRk9SIEFOWSBDTEFJTSwgREFNQUdFUyBPUiBPVEhFUlxuLy8gTElBQklMSVRZLCBXSEVUSEVSIElOIEFOIEFDVElPTiBPRiBDT05UUkFDVCwgVE9SVCBPUiBPVEhFUldJU0UsIEFSSVNJTkcgRlJPTSxcbi8vIE9VVCBPRiBPUiBJTiBDT05ORUNUSU9OIFdJVEggVEhFIFNPRlRXQVJFIE9SIFRIRSBVU0UgT1IgT1RIRVIgREVBTElOR1MgSU5cbi8vIFRIRSBTT0ZUV0FSRS5cblxuZXhwb3J0IGRlZmF1bHQgYFxcXG4jZGVmaW5lIFNIQURFUl9OQU1FIG11bHRpLWljb24tbGF5ZXItdmVydGV4LXNoYWRlci02NFxuXG5hdHRyaWJ1dGUgdmVjMiBwb3NpdGlvbnM7XG5cbmF0dHJpYnV0ZSB2ZWMzIGluc3RhbmNlUG9zaXRpb25zO1xuYXR0cmlidXRlIHZlYzIgaW5zdGFuY2VQb3NpdGlvbnM2NHh5TG93O1xuYXR0cmlidXRlIGZsb2F0IGluc3RhbmNlU2l6ZXM7XG5hdHRyaWJ1dGUgZmxvYXQgaW5zdGFuY2VBbmdsZXM7XG5hdHRyaWJ1dGUgdmVjNCBpbnN0YW5jZUNvbG9ycztcbmF0dHJpYnV0ZSB2ZWMzIGluc3RhbmNlUGlja2luZ0NvbG9ycztcbmF0dHJpYnV0ZSB2ZWM0IGluc3RhbmNlSWNvbkZyYW1lcztcbmF0dHJpYnV0ZSBmbG9hdCBpbnN0YW5jZUNvbG9yTW9kZXM7XG5hdHRyaWJ1dGUgdmVjMiBpbnN0YW5jZU9mZnNldHM7XG5cbi8vIHRoZSBmb2xsb3dpbmcgdGhyZWUgYXR0cmlidXRlcyBhcmUgZm9yIHRoZSBtdWx0aS1pY29uIGxheWVyXG5hdHRyaWJ1dGUgZmxvYXQgaW5zdGFuY2VJbmRleE9mSWNvbjtcbmF0dHJpYnV0ZSBmbG9hdCBpbnN0YW5jZU51bU9mSWNvbjtcbmF0dHJpYnV0ZSB2ZWMyIGluc3RhbmNlUGl4ZWxPZmZzZXQ7XG5cbnVuaWZvcm0gZmxvYXQgc2l6ZVNjYWxlO1xudW5pZm9ybSB2ZWMyIGljb25zVGV4dHVyZURpbTtcblxudmFyeWluZyBmbG9hdCB2Q29sb3JNb2RlO1xudmFyeWluZyB2ZWM0IHZDb2xvcjtcbnZhcnlpbmcgdmVjMiB2VGV4dHVyZUNvb3JkcztcblxudmVjMiByb3RhdGVfYnlfYW5nbGUodmVjMiB2ZXJ0ZXgsIGZsb2F0IGFuZ2xlKSB7XG4gIGZsb2F0IGFuZ2xlX3JhZGlhbiA9IGFuZ2xlICogUEkgLyAxODAuMDtcbiAgZmxvYXQgY29zX2FuZ2xlID0gY29zKGFuZ2xlX3JhZGlhbik7XG4gIGZsb2F0IHNpbl9hbmdsZSA9IHNpbihhbmdsZV9yYWRpYW4pO1xuICBtYXQyIHJvdGF0aW9uTWF0cml4ID0gbWF0Mihjb3NfYW5nbGUsIC1zaW5fYW5nbGUsIHNpbl9hbmdsZSwgY29zX2FuZ2xlKTtcbiAgcmV0dXJuIHJvdGF0aW9uTWF0cml4ICogdmVydGV4O1xufVxuXG52ZWMyIGdldFNoaWZ0KGZsb2F0IGluc3RhbmNlSW5kZXhPZkljb24sIGZsb2F0IGluc3RhbmNlTnVtT2ZJY29uKSB7XG4gIC8vIGNhbGN1bGF0ZSB0aGUgbWlkZGxlIGluZGV4IG9mIHRoZSBzdHJpbmdcbiAgZmxvYXQgbWlkSW5kZXggPSAoaW5zdGFuY2VOdW1PZkljb24gLSAxLjApIC8gMi4wO1xuICAvLyBjYWxjdWxhdGUgaG9yaXpvbnRhbCBzaGlmdCBvZiBlYWNoIGxldHRlclxuICByZXR1cm4gdmVjMihpbnN0YW5jZUluZGV4T2ZJY29uIC0gbWlkSW5kZXgsIDAuMCk7XG59XG5cbnZvaWQgbWFpbih2b2lkKSB7XG4gIHZlYzIgaWNvblNpemUgPSBpbnN0YW5jZUljb25GcmFtZXMuenc7XG4gIC8vIHNjYWxlIGljb24gaGVpZ2h0IHRvIG1hdGNoIGluc3RhbmNlU2l6ZVxuICBmbG9hdCBpbnN0YW5jZVNjYWxlID0gaWNvblNpemUueSA9PSAwLjAgPyAwLjAgOiBpbnN0YW5jZVNpemVzIC8gaWNvblNpemUueTtcblxuICAvLyBzY2FsZSBhbmQgcm90YXRlIHZlcnRleCBpbiBcInBpeGVsXCIgdmFsdWUgYW5kIGNvbnZlcnQgYmFjayB0byBmcmFjdGlvbiBpbiBjbGlwc3BhY2VcbiAgdmVjMiBzaGlmdCA9IGdldFNoaWZ0KGluc3RhbmNlSW5kZXhPZkljb24sIGluc3RhbmNlTnVtT2ZJY29uKTtcbiAgdmVjMiBwaXhlbE9mZnNldCA9IChwb3NpdGlvbnMgLyAyLjAgKyBzaGlmdCkgKiBpY29uU2l6ZSArIGluc3RhbmNlT2Zmc2V0cztcblxuICBwaXhlbE9mZnNldCA9IHJvdGF0ZV9ieV9hbmdsZShwaXhlbE9mZnNldCwgaW5zdGFuY2VBbmdsZXMpICogc2l6ZVNjYWxlICogaW5zdGFuY2VTY2FsZTtcbiAgcGl4ZWxPZmZzZXQgKz0gaW5zdGFuY2VQaXhlbE9mZnNldDtcbiAgcGl4ZWxPZmZzZXQueSAqPSAtMS4wO1xuXG4gIHZlYzQgaW5zdGFuY2VQb3NpdGlvbnM2NHh5ID0gdmVjNChcbiAgaW5zdGFuY2VQb3NpdGlvbnMueCwgaW5zdGFuY2VQb3NpdGlvbnM2NHh5TG93LngsXG4gIGluc3RhbmNlUG9zaXRpb25zLnksIGluc3RhbmNlUG9zaXRpb25zNjR4eUxvdy55KTtcblxuICB2ZWMyIHByb2plY3RlZF9jb29yZF94eVsyXTtcbiAgcHJvamVjdF9wb3NpdGlvbl9mcDY0KGluc3RhbmNlUG9zaXRpb25zNjR4eSwgcHJvamVjdGVkX2Nvb3JkX3h5KTtcblxuICB2ZWMyIHZlcnRleF9wb3NfbW9kZWxzcGFjZVs0XTtcbiAgdmVydGV4X3Bvc19tb2RlbHNwYWNlWzBdID0gcHJvamVjdGVkX2Nvb3JkX3h5WzBdO1xuICB2ZXJ0ZXhfcG9zX21vZGVsc3BhY2VbMV0gPSBwcm9qZWN0ZWRfY29vcmRfeHlbMV07XG4gIHZlcnRleF9wb3NfbW9kZWxzcGFjZVsyXSA9IHZlYzIocHJvamVjdF9zY2FsZShpbnN0YW5jZVBvc2l0aW9ucy56KSwgMC4wKTtcbiAgdmVydGV4X3Bvc19tb2RlbHNwYWNlWzNdID0gdmVjMigxLjAsIDAuMCk7XG5cbiAgZ2xfUG9zaXRpb24gPSBwcm9qZWN0X3RvX2NsaXBzcGFjZV9mcDY0KHZlcnRleF9wb3NfbW9kZWxzcGFjZSk7XG4gIGdsX1Bvc2l0aW9uICs9IHByb2plY3RfcGl4ZWxfdG9fY2xpcHNwYWNlKHBpeGVsT2Zmc2V0KTtcblxuICB2VGV4dHVyZUNvb3JkcyA9IG1peChcbiAgICBpbnN0YW5jZUljb25GcmFtZXMueHksXG4gICAgaW5zdGFuY2VJY29uRnJhbWVzLnh5ICsgaWNvblNpemUsXG4gICAgKHBvc2l0aW9ucy54eSArIDEuMCkgLyAyLjBcbiAgKSAvIGljb25zVGV4dHVyZURpbTtcblxuICB2VGV4dHVyZUNvb3Jkcy55ID0gMS4wIC0gdlRleHR1cmVDb29yZHMueTtcblxuICB2Q29sb3IgPSBpbnN0YW5jZUNvbG9ycyAvIDI1NS47XG4gIHBpY2tpbmdfc2V0UGlja2luZ0NvbG9yKGluc3RhbmNlUGlja2luZ0NvbG9ycyk7XG5cbiAgdkNvbG9yTW9kZSA9IGluc3RhbmNlQ29sb3JNb2Rlcztcbn1cbmA7XG4iXX0=