'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadImage = loadImage;

var _utils = require('../../utils');

function loadImage(url) {
  var getPixels = module.require('get-pixels');
  if (!getPixels) {
    throw new Error('loadImage: get-pixels not installed');
  }

  return (0, _utils.promisify)(getPixels)(url);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9sdW1hLmdsL2lvLWJhc2ljL25vZGUtbG9hZC1pbWFnZS5qcyJdLCJuYW1lcyI6WyJsb2FkSW1hZ2UiLCJ1cmwiLCJnZXRQaXhlbHMiLCJtb2R1bGUiLCJyZXF1aXJlIiwiRXJyb3IiXSwibWFwcGluZ3MiOiI7Ozs7O1FBRWdCLEEsWUFBQSxBOztBQUZoQjs7QUFFTyxTQUFTLEFBQVQsVUFBbUIsQUFBbkIsS0FBd0IsQUFDN0I7TUFBTSxZQUFZLE9BQU8sQUFBUCxRQUFlLEFBQWYsQUFBbEIsQUFDQTtNQUFJLENBQUMsQUFBTCxXQUFnQixBQUNkO1VBQU0sSUFBSSxBQUFKLE1BQVUsQUFBVixBQUFOLEFBQ0Q7QUFFRDs7U0FBTyxzQkFBVSxBQUFWLFdBQXFCLEFBQXJCLEFBQVAsQUFDRCIsImZpbGUiOiJub2RlLWxvYWQtaW1hZ2UuanMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge3Byb21pc2lmeX0gZnJvbSAnLi4vLi4vdXRpbHMnO1xuXG5leHBvcnQgZnVuY3Rpb24gbG9hZEltYWdlKHVybCkge1xuICBjb25zdCBnZXRQaXhlbHMgPSBtb2R1bGUucmVxdWlyZSgnZ2V0LXBpeGVscycpO1xuICBpZiAoIWdldFBpeGVscykge1xuICAgIHRocm93IG5ldyBFcnJvcignbG9hZEltYWdlOiBnZXQtcGl4ZWxzIG5vdCBpbnN0YWxsZWQnKTtcbiAgfVxuXG4gIHJldHVybiBwcm9taXNpZnkoZ2V0UGl4ZWxzKSh1cmwpO1xufVxuIl19