'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () {
  function defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }return function (Constructor, protoProps, staticProps) {
    if (protoProps) defineProperties(Constructor.prototype, protoProps);if (staticProps) defineProperties(Constructor, staticProps);return Constructor;
  };
}(); // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/* global setTimeout */

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _deck = require('deck.gl');

var _browserImageUtils = require('./luma.gl/io-basic/browser-image-utils');

function _interopRequireDefault(obj) {
  return obj && obj.__esModule ? obj : { default: obj };
}

function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}

var Deck = _deck.experimental.Deck,
    DeckGLJS = _deck.experimental.DeckGLJS,
    MapView = _deck.experimental.MapView;

function noop() {}

function makePromise() {
  var resolve = void 0;
  var reject = void 0;
  var promise = new Promise(function (resolve_, reject_) {
    resolve = resolve_;
    reject = reject_;
  });
  promise.resolve = resolve;
  promise.reject = reject;
  return promise;
}

var SceneRenderer = function () {
  function SceneRenderer() {
    var _ref = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {},
        scenes = _ref.scenes,
        _ref$width = _ref.width,
        width = _ref$width === undefined ? 800 : _ref$width,
        _ref$height = _ref.height,
        height = _ref$height === undefined ? 450 : _ref$height,
        onSceneRendered = _ref.onSceneRendered,
        _ref$onComplete = _ref.onComplete,
        onComplete = _ref$onComplete === undefined ? noop : _ref$onComplete;

    _classCallCheck(this, SceneRenderer);

    (0, _assert2.default)(scenes);

    this.width = width;
    this.height = height;
    this.scenes = scenes;
    this.running = false;
    this.complete = true;
    this.onSceneRendered = onSceneRendered;
    this.onComplete = onComplete;
  }

  _createClass(SceneRenderer, [{
    key: 'run',
    value: function run() {
      // TODO - for 5.1 compatibility, remove when 5.2 is released
      var DeckGL = Deck || DeckGLJS;
      this.deckgl = new DeckGL({
        id: 'default-deckgl-overlay',
        style: { position: 'absolute', left: '0px', top: '0px' },
        layers: [],
        width: this.width,
        height: this.height,
        debug: true,
        autoResizeDrawingBuffer: false,
        useDevicePixels: false
      });

      this.running = true;
      this.complete = false;
      this.sceneIndex = 0;
      this._renderNextScene();
    }
  }, {
    key: 'stop',
    value: function stop() {
      this.running = false;
    }

    // PRIVATE METHODS

  }, {
    key: '_onAfterRender',
    value: function _onAfterRender(promise, scene, _ref2) {
      var _this = this;

      var gl = _ref2.gl;

      (0, _browserImageUtils.getImageFromContext)(gl).then(function (image) {
        image.style.mixBlendMode = 'difference';
        var params = Object.assign({ gl: gl, image: image }, scene);
        return _this.onSceneRendered(params);
      }).then(function (x) {
        return promise.resolve(x);
      }).catch(function (error) {
        return promise.reject(error);
      });
    }
  }, {
    key: '_renderScene',
    value: function _renderScene(scene) {
      var _this2 = this;

      var viewState = scene.viewState,
          layers = scene.layers,
          views = scene.views,
          viewports = scene.viewports,
          _scene$timeout = scene.timeout,
          timeout = _scene$timeout === undefined ? 0 : _scene$timeout;

      var promise = makePromise();

      // Initial render to get layer loading
      this.deckgl.setProps({
        layers: layers,
        views: views || [new MapView()],
        viewState: viewState,
        onAfterRender: function onAfterRender() {},

        // DEPRECATED - temporary 5.1 compatibility, remove when 5.2 is released
        viewports: viewports
      });

      // Render again after a timeout to allow layer to load
      // This time the afterRender function will resolve the promise
      setTimeout(function () {
        _this2.deckgl.setProps({
          layers: layers,
          onAfterRender: _this2._onAfterRender.bind(_this2, promise, scene)
        });
      }, timeout);

      // promise that resolves when scene is rendered
      return promise;
    }
  }, {
    key: '_renderNextScene',
    value: function _renderNextScene() {
      var _this3 = this;

      var scene = this.scenes[this.sceneIndex];
      if (this.sceneIndex >= this.scenes.length) {
        this.running = false;
      } else {
        this.sceneIndex++;
      }

      if (this.running) {
        var params = Object.assign({ index: this.sceneIndex }, scene);
        console.log('Rendering new scene with layers', params); // eslint-disable-line

        this._renderScene(params).then(function () {
          return _this3._renderNextScene();
        }).catch(function () {
          return _this3._renderNextScene();
        });
      } else if (!this.complete) {
        this.complete = true;
        this.onComplete();
      }
    }
  }]);

  return SceneRenderer;
}();

exports.default = SceneRenderer;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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