'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

var _test = require('probe.gl/test');

var _probe = require('probe.gl');

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

function _possibleConstructorReturn(self, call) { if (!self) { throw new ReferenceError("this hasn't been initialised - super() hasn't been called"); } return call && (typeof call === "object" || typeof call === "function") ? call : self; }

function _inherits(subClass, superClass) { if (typeof superClass !== "function" && superClass !== null) { throw new TypeError("Super expression must either be null or a function, not " + typeof superClass); } subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, enumerable: false, writable: true, configurable: true } }); if (superClass) Object.setPrototypeOf ? Object.setPrototypeOf(subClass, superClass) : subClass.__proto__ = superClass; } // Copyright (c) 2015 - 2017 Uber Technologies, Inc.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

/* global process */


var log = new _probe.Log('render-test');

// DEFAULT config, intended to be overridden in the node script that calls us

// read the webpack env from 3 arg (node script arg)
var webpackEnv = 'render';
if (process.argv.length >= 3) {
  webpackEnv = process.argv[2];
}

var SERVER_CONFIG = {
  parameters: ['--env.' + webpackEnv]
};

var RenderTestDriver = function (_BrowserDriver) {
  _inherits(RenderTestDriver, _BrowserDriver);

  function RenderTestDriver() {
    _classCallCheck(this, RenderTestDriver);

    return _possibleConstructorReturn(this, (RenderTestDriver.__proto__ || Object.getPrototypeOf(RenderTestDriver)).apply(this, arguments));
  }

  _createClass(RenderTestDriver, [{
    key: 'run',
    value: function run() {
      var _this2 = this;

      var config = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : SERVER_CONFIG;

      log.log({ message: 'Running rendering tests in Chrome instance...', color: _probe.COLOR.YELLOW })();
      this.time = Date.now();
      return Promise.resolve().then(function (_) {
        return _this2.startServer(config);
      }).then(function (_) {
        return _this2.startBrowser();
      }).then(function (_) {
        return _this2.newPage();
      }).then(function (_) {
        return _this2.waitForBrowserMessage('renderTestComplete');
      }).then(function (resultString) {
        var result = JSON.parse(resultString);
        if (result.success !== Boolean(result.success) || typeof result.failedTest !== 'string') {
          throw new Error('Illegal response "' + resultString + '" returned from Chrome test script');
        }
        if (!result.success) {
          throw new Error(result.failedTest);
        }
        _this2._success();
      }).catch(function (error) {
        _this2._failure(error);
      });
    }
  }, {
    key: '_success',
    value: function _success() {
      var elapsed = ((Date.now() - this.time) / 1000).toFixed(1);
      log.log({
        message: 'Rendering test successfully completed in ' + elapsed + 's!',
        color: _probe.COLOR.BRIGHT_GREEN
      })();
      this.setShellStatus(true);
      this.exit();
    }
  }, {
    key: '_failure',
    value: function _failure(error) {
      log.error({
        message: 'Rendering test failed: ' + error.message,
        color: _probe.COLOR.BRIGHT_RED
      })();
      // Don't call exit(). Leave browser running so user can inspect image that failed to render
      this.setShellStatus(false);
      return Promise.all([
      // this.stopBrowser(), // Don't stop the browser
      this.stopServer()]).then(function (_) {
        // this.exitProcess()); - Don't exit the process
      });
    }
  }]);

  return RenderTestDriver;
}(_test.BrowserDriver);

exports.default = RenderTestDriver;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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