'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createImage = createImage;
exports.getImageFromContext = getImageFromContext;
exports.getImagePixelData = getImagePixelData;
// TODO - only works in browser
/* global document */

function createImage(width, height) {
  var image = document.createElement('img');
  image.width = width;
  image.height = height;
  image.style.position = 'absolute';
  image.style.top = 0;
  image.style.left = 0;
  return image;
}

function getImageFromContext(gl) {
  var image = createImage(gl.drawingBufferWidth, gl.drawingBufferHeight);
  return new Promise(function (resolve) {
    image.onload = function () {
      resolve(image);
    };
    image.src = gl.canvas.toDataURL();
  });
}

function getImagePixelData(image) {
  var width = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;
  var height = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : null;

  width = width || image.width;
  height = height || image.height;

  var canvas = document.createElement('canvas');
  canvas.width = width;
  canvas.height = height;
  var ctx = canvas.getContext('2d');
  ctx.drawImage(image, 0, 0, width, height);
  return ctx.getImageData(0, 0, width, height);
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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