'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadImage = loadImage;

var _pathPrefix = require('./path-prefix');

/* global Image */

/*
 * Loads images asynchronously
 * image.crossOrigin can be set via opts.crossOrigin, default to 'anonymous'
 * returns a promise tracking the load
 */
function loadImage(url, opts) {
  var pathPrefix = (0, _pathPrefix.getPathPrefix)();
  url = pathPrefix ? pathPrefix + url : url;

  return new Promise(function (resolve, reject) {
    try {
      var image = new Image();
      image.onload = function () {
        return resolve(image);
      };
      image.onerror = function () {
        return reject(new Error('Could not load image ' + url + '.'));
      };
      image.crossOrigin = opts && opts.crossOrigin || 'anonymous';
      image.src = url;
    } catch (error) {
      reject(error);
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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