'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

exports.loadModel = loadModel;
exports.parseModel = parseModel;

var _browserLoadFile = require('./browser-load-file');

var _webgl = require('../webgl');

var _core = require('../core');

var _geometry = require('../geometry');

// Loads a simple JSON format
function loadModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  return (0, _browserLoadFile.loadFile)(opts).then(function (_ref) {
    var _ref2 = _slicedToArray(_ref, 1),
        file = _ref2[0];

    return parseModel(gl, Object.assign({ file: file }, opts));
  });
}

function parseModel(gl) {
  var opts = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var file = opts.file,
      _opts$program = opts.program,
      program = _opts$program === undefined ? new _webgl.Program(gl) : _opts$program;

  var json = typeof file === 'string' ? parseJSON(file) : file;
  // Remove any attributes so that we can create a geometry
  // TODO - change format to put these in geometry sub object?
  var attributes = {};
  var modelOptions = {};
  for (var key in json) {
    var value = json[key];
    if (Array.isArray(value)) {
      attributes[key] = key === 'indices' ? new Uint16Array(value) : new Float32Array(value);
    } else {
      modelOptions[key] = value;
    }
  }

  return new _core.Model(gl, Object.assign({ program: program, geometry: new _geometry.Geometry({ attributes: attributes }) }, modelOptions, opts));
}

function parseJSON(file) {
  try {
    return JSON.parse(file);
  } catch (error) {
    throw new Error('Failed to parse JSON: ' + error);
  }
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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