'use strict';

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.loadFiles = loadFiles;
exports.loadImages = loadImages;

var _assert = require('assert');

var _assert2 = _interopRequireDefault(_assert);

var _browserLoadFile = require('./browser-load-file');

var _browserLoadImage = require('./browser-load-image');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function noop() {}

/*
 * Loads (Requests) multiple files asynchronously
 */
/* eslint-disable guard-for-in, complexity, no-try-catch */
function loadFiles() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var urls = opts.urls,
      _opts$onProgress = opts.onProgress,
      onProgress = _opts$onProgress === undefined ? noop : _opts$onProgress;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadImages: {urls} must be array of strings');
  var count = 0;
  return Promise.all(urls.map(function (url) {
    var promise = (0, _browserLoadFile.loadFile)(Object.assign({ url: url }, opts));
    promise.then(function (file) {
      return onProgress({
        progress: ++count / urls.length,
        count: count,
        total: urls.length,
        url: url
      });
    });
    return promise;
  }));
}

/*
 * Loads (requests) multiple images asynchronously
 */
function loadImages() {
  var opts = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  var urls = opts.urls,
      _opts$onProgress2 = opts.onProgress,
      onProgress = _opts$onProgress2 === undefined ? noop : _opts$onProgress2;

  (0, _assert2.default)(urls.every(function (url) {
    return typeof url === 'string';
  }), 'loadImages: {urls} must be array of strings');
  var count = 0;
  return Promise.all(urls.map(function (url) {
    var promise = (0, _browserLoadImage.loadImage)(url, opts);
    promise.then(function (file) {
      return onProgress({
        progress: ++count / urls.length,
        count: count,
        total: urls.length,
        url: url
      });
    });
    return promise;
  }));
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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