'use strict';

require('../../../src/headless');

var _io = require('../../../src/io');

var _setup = require('../../setup');

var _setup2 = _interopRequireDefault(_setup);

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/* eslint-disable quotes */
var PNG_BITS = 'iVBORw0KGgoAAAANSUhEUgAAAAIAAAACCAYAAABytg0kAAAAFElEQVQIW2P8z/D/PwMDAwMjjAEAQOwF/W1Dp54AAAAASUVORK5CYII=';
/* eslint-enable quotes */

var DATA_URL = 'data:image/png;base64,' + PNG_BITS;

(0, _setup2.default)('io#read-image', function (t) {
  (0, _io.loadImage)(DATA_URL).then(function (image) {
    t.equals(image.width, 2, 'width');
    t.equals(image.height, 2, 'height');
    t.end();
  });
});
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9sdW1hLmdsL3Rlc3QvcmVhZC1pbWFnZS5zcGVjLmpzIl0sIm5hbWVzIjpbIlBOR19CSVRTIiwiREFUQV9VUkwiLCJ0aGVuIiwidCIsImVxdWFscyIsImltYWdlIiwid2lkdGgiLCJoZWlnaHQiLCJlbmQiXSwibWFwcGluZ3MiOiI7O0FBQUE7O0FBQ0E7O0FBQ0E7Ozs7OztBQUVBO0FBQ0EsSUFBTUEscUhBQU47QUFHQTs7QUFFQSxJQUFNQyxzQ0FBb0NELFFBQTFDOztBQUVBLHFCQUFLLGVBQUwsRUFBc0IsYUFBSztBQUN6QixxQkFBVUMsUUFBVixFQUFvQkMsSUFBcEIsQ0FBeUIsaUJBQVM7QUFDaENDLE1BQUVDLE1BQUYsQ0FBU0MsTUFBTUMsS0FBZixFQUFzQixDQUF0QixFQUF5QixPQUF6QjtBQUNBSCxNQUFFQyxNQUFGLENBQVNDLE1BQU1FLE1BQWYsRUFBdUIsQ0FBdkIsRUFBMEIsUUFBMUI7QUFDQUosTUFBRUssR0FBRjtBQUNELEdBSkQ7QUFLRCxDQU5EIiwiZmlsZSI6InJlYWQtaW1hZ2Uuc3BlYy5qcyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAnLi4vLi4vLi4vc3JjL2hlYWRsZXNzJztcbmltcG9ydCB7bG9hZEltYWdlfSBmcm9tICcuLi8uLi8uLi9zcmMvaW8nO1xuaW1wb3J0IHRlc3QgZnJvbSAnLi4vLi4vc2V0dXAnO1xuXG4vKiBlc2xpbnQtZGlzYWJsZSBxdW90ZXMgKi9cbmNvbnN0IFBOR19CSVRTID0gYFxcXG5pVkJPUncwS0dnb0FBQUFOU1VoRVVnQUFBQUlBQUFBQ0NBWUFBQUJ5dGcwa0FBQUFGRWxFUVZRSVcyUDh6XFxcbi9EL1B3TURBd01qakFFQVFPd0YvVzFEcDU0QUFBQUFTVVZPUks1Q1lJST1gO1xuLyogZXNsaW50LWVuYWJsZSBxdW90ZXMgKi9cblxuY29uc3QgREFUQV9VUkwgPSBgZGF0YTppbWFnZS9wbmc7YmFzZTY0LCR7UE5HX0JJVFN9YDtcblxudGVzdCgnaW8jcmVhZC1pbWFnZScsIHQgPT4ge1xuICBsb2FkSW1hZ2UoREFUQV9VUkwpLnRoZW4oaW1hZ2UgPT4ge1xuICAgIHQuZXF1YWxzKGltYWdlLndpZHRoLCAyLCAnd2lkdGgnKTtcbiAgICB0LmVxdWFscyhpbWFnZS5oZWlnaHQsIDIsICdoZWlnaHQnKTtcbiAgICB0LmVuZCgpO1xuICB9KTtcbn0pO1xuIl19