# Changelog
All notable changes to this project will be documented in this file.

## [0.0.30] - 2020-07-14
### Fixed
- do not consider a single escape character as being an argument for the instruction ([#83](https://github.com/rcjsuen/dockerfile-ast/issues/83))
- do not consider a single escape character as being a property for an instruction ([#84](https://github.com/rcjsuen/dockerfile-ast/issues/84))

## [0.0.29] - 2020-07-12
### Fixed
- ignore leading whitespace before a comment in escaped newlines for `getArgumentsContent()` and `getArgumentsRanges()` of `Instruction` ([#82](https://github.com/rcjsuen/dockerfile-ast/issues/82))

## [0.0.28] - 2020-07-11
### Fixed
- improve handling of trailing whitespace that is not a newline character after an escape character ([#81](https://github.com/rcjsuen/dockerfile-ast/issues/81))

## [0.0.27] - 2020-06-17
### Fixed
- allow comments to immediately follow the declaration of an ARG or ENV instruction ([#80](https://github.com/rcjsuen/dockerfile-ast/issues/80))

## [0.0.26] - 2020-04-22
### Fixed
- correct range of multiline arguments that end with a character preceded by an escape character ([#78](https://github.com/rcjsuen/dockerfile-ast/issues/78))
- correct range of arguments that are split on multiple lines with escaped whitespace lines in between ([#77](https://github.com/rcjsuen/dockerfile-ast/issues/77))
- enable parsing of flag options that do not have a value defined ([#79](https://github.com/rcjsuen/dockerfile-ast/issues/79))

## [0.0.25] - 2020-04-01
### Added
- `Flag`
  - `getOptions()` ([#75](https://github.com/rcjsuen/dockerfile-ast/issues/75))
  - `getOption(string)` ([#75](https://github.com/rcjsuen/dockerfile-ast/issues/75))
  - `hasOptions()` ([#75](https://github.com/rcjsuen/dockerfile-ast/issues/75))
- `FlagOption` ([#75](https://github.com/rcjsuen/dockerfile-ast/issues/75))
- `Run` ([#76](https://github.com/rcjsuen/dockerfile-ast/issues/76))
  - `RUN` instructions will now of type `Run` instead of `JSONInstruction`
  - `Run` extends `JSONInstruction` so this is not be a breaking change

### Fixed
- allow `From`'s `getBuildStage()` and `getBuildStageRange()` to return non-`null` values even if the instruction has more than three arguments as long as parts of it is valid ([#74](https://github.com/rcjsuen/dockerfile-ast/issues/74))

## [0.0.24] - 2020-03-08
### Fixed
- `Instruction`'s `getArguments()` will no longer exclude arguments that follow an embedded comment that ends with the escape character ([#73](https://github.com/rcjsuen/dockerfile-ast/issues/73))

## [0.0.23] - 2020-03-08
### Fixed
- `Instruction`'s `getArguments()` will no longer incorrectly exclude arguments because they look like comments ([#72](https://github.com/rcjsuen/dockerfile-ast/issues/72))

## [0.0.22] - 2020-03-07
### Fixed
- instructions will no longer be cut off prematurely due to empty continuation lines embedded in the keyword itself ([#70](https://github.com/rcjsuen/dockerfile-ast/issues/70))
- `Instruction`'s `getArguments()` will now correctly account for multiple embedded comments instead of considering them as an argument ([#71](https://github.com/rcjsuen/dockerfile-ast/issues/71))

## [0.0.21] - 2020-02-27
### Fixed
- `Instruction`'s `getArgumentsRanges()` will no longer throw an error if an instruction spans multiple lines and has escaped newlines at the beginning of a line ([#67](https://github.com/rcjsuen/dockerfile-ast/issues/67))
- `ModifiableInstruction`'s `toString()` will now include the instruction's flags ([#68](https://github.com/rcjsuen/dockerfile-ast/issues/68))
- `ModifiableInstruction`'s `getVariables()` will now include variables that are used in the instruction's flags ([#69](https://github.com/rcjsuen/dockerfile-ast/issues/69))

## [0.0.20] - 2020-02-11
### Added
- `Dockerfile`
  - `getDirectives()` ([#62](https://github.com/rcjsuen/dockerfile-ast/issues/62))
    - originally introduced in 0.0.18 to support compatibility in the future, the function is now fully implemented and will return an ordered list of all the parser directives defined at the top of the Dockerfile

- `Directive`
  - `syntax` ([#63](https://github.com/rcjsuen/dockerfile-ast/issues/63))
    - this enum can be used for identifying the `syntax` parser directive used by BuildKit

### Changed
- `ParserDirective`
  - `getDirective()` ([#63](https://github.com/rcjsuen/dockerfile-ast/issues/63))
    - this function originally stated that it would return a `Directive`
    - `undefined` would be returned if the name of the parser directive was not recognized
    - the function now returns `Directive | null`
    - the function will return `null` if the parser directive is not recognized instead of `undefined`

### Fixed
- `Instruction`'s `getArgumentsRanges()` will no longer throw an error if the instruction has its last argument on its own line with no leading whitespace and the length of that argument is one ([#66](https://github.com/rcjsuen/dockerfile-ast/issues/66))

## [0.0.19] - 2020-01-27
### Added
- `From`
  - `getPlatformFlag()` ([#65](https://github.com/rcjsuen/dockerfile-ast/issues/65))

### Changed
- `From`
  - this class now subclasses `ModifiableInstruction` instead of `Instruction` ([#65](https://github.com/rcjsuen/dockerfile-ast/issues/65))
    - this was changed to support the `--platform` flag introduced in Docker CE 18.04
    - as `ModifiableInstruction` extends `Instruction`, this should not impact anyone at an API level from a compilation standpoint
    - note that this will break users that previously used `getArguments()` to parse and retrieve the `--platform` flag manually, please replace such usages with the new `getPlatformFlag()` API

## [0.0.18] - 2019-12-07
### Added
- `Dockerfile`
  - `getDirectives()` ([#64](https://github.com/rcjsuen/dockerfile-ast/issues/64))

### Changed
- `getDirective()` of `Dockerfile` has been deprecated and will be replaced by `getDirectives()` in the future ([#64](https://github.com/rcjsuen/dockerfile-ast/issues/64))
  - note that this is purely a cosmetic API change to facilitate migration at the moment, proper support for returning an array will follow in the future

### Fixed
- add support for TypeScript 3.7 by fixing TS2440 compiler error ([#61](https://github.com/rcjsuen/dockerfile-ast/issues/61))

## [0.0.17] - 2019-10-13
### Fixed
- correct parsing of image names that were incorrectly identified as a Docker registry ([#59](https://github.com/rcjsuen/dockerfile-ast/issues/59))

## [0.0.16] - 2019-05-22
### Fixed
- only allow alphanumeric and underscore characters in variable names ([#58](https://github.com/rcjsuen/dockerfile-ast/issues/58))

## [0.0.15] - 2019-05-21
### Fixed
- variables in `FROM` should return `true` for `isDefined()` if it is defined in the `ARG` instructions above it ([#56](https://github.com/rcjsuen/dockerfile-ast/issues/56))
- variables in `FROM` should return `true` for `isBuildVariable()` if it is defined in the `ARG` instructions above it ([#57](https://github.com/rcjsuen/dockerfile-ast/issues/57))

## [0.0.14] - 2019-04-28
### Added
- `ImageTemplate`
  - `getRange()` ([#53](https://github.com/rcjsuen/dockerfile-ast/issues/53))

### Changed
- the enum value for `Keyword.ADD` was incorrectly assigned to `"ARG"`, it is now assigned to `"ADD"` ([#51](https://github.com/rcjsuen/dockerfile-ast/issues/51))
  - this is a breaking change but presumably no consumers were relying on this incorrect behaviour
- `Dockerfile`'s `getContainingImage()` has been changed for comments immediately before a build stage
  - previously, they would return the build stage that came after the comment, now they will simply return the entire Dockerfile
  - this is because the comment is actually ambiguous as it may be a commented out instruction for the build stage that came before the comment

### Fixed
- correct incorrectly assigned string enum value for `Keyword.ADD` ([#51](https://github.com/rcjsuen/dockerfile-ast/issues/51))
- ensure quotation marks and apostrophes are included for expanded arguments in `Instruction`'s `getExpandedArguments()` if they surround a variable ([#52](https://github.com/rcjsuen/dockerfile-ast/issues/52))
- fixed `getComments()` for build stages so that they will not simply return empty arrays ([#54](https://github.com/rcjsuen/dockerfile-ast/issues/54))
  - the returned comments will only be from comments contained within the `FROM` instruction and the last instruction of that build stage

## [0.0.13] - 2018-12-20
### Fixed
- prevent TypeError from being thrown by `Dockerfile`'s `resolveVariable(string, number)` when an invalid line number is provided ([#48](https://github.com/rcjsuen/dockerfile-ast/issues/48))
- correct compiler error due to incomplete interface signature ([#46](https://github.com/rcjsuen/dockerfile-ast/issues/46))

## [0.0.12] - 2018-08-10
### Fixed
- handle quoted properties on separate lines properly for `ENV`s and `LABEL`s ([#44](https://github.com/rcjsuen/dockerfile-ast/issues/45))

## [0.0.11] - 2018-06-16
### Fixed
- ignore initial `ENV`s when resolving variables in `FROM`s ([#44](https://github.com/rcjsuen/dockerfile-ast/issues/44))

## [0.0.10] - 2018-06-16
### Added
- `From`
  - `getImageRange()` ([#43](https://github.com/rcjsuen/dockerfile-ast/issues/43))
  - `getImageTag()` ([#43](https://github.com/rcjsuen/dockerfile-ast/issues/43))
  - `getImageDigest()` ([#43](https://github.com/rcjsuen/dockerfile-ast/issues/43))
  - `getRegistry()` ([#43](https://github.com/rcjsuen/dockerfile-ast/issues/43))
  - `getRegistryRange()` ([#43](https://github.com/rcjsuen/dockerfile-ast/issues/43))

### Changed
- [upgraded the dependency of Mocha](https://github.com/mochajs/mocha/issues/2791) from 3.x to 5.x
  - versions prior to 4.x of Mocha dependended on Growl 1.9.2 which contained a [security vulnerability](https://github.com/tj/node-growl/issues/60)
  - as Mocha is a `devDependencies` module, there is no reason to believe that the `dockerfile-ast` module itself was affected by this vulnerability

### Fixed
- do not resolve reinitialized `ARG` variables with `ENV` instructions at the top of the Dockerfile ([#42](https://github.com/rcjsuen/dockerfile-ast/issues/42))
- improve parsing of `FROM` instructions that refer to variables ([#39](https://github.com/rcjsuen/dockerfile-ast/issues/39))

## [0.0.9] - 2018-05-28
### Fixed
- handle comments in the last line of a file properly for `ARG`, `ENV`, and `LABEL` ([#40](https://github.com/rcjsuen/dockerfile-ast/issues/40))
- parse `ARG` instructions properly when its value contains an unclosed quote ([#41](https://github.com/rcjsuen/dockerfile-ast/issues/41))

## [0.0.8] - 2018-05-27
### Fixed
- prevent `getVariables()` from throwing an error if a `LABEL` has no value defined ([#38](https://github.com/rcjsuen/dockerfile-ast/issues/38))

## [0.0.7] - 2018-05-25
### Added
- `ParserDirective`
  - `toString()` ([#4](https://github.com/rcjsuen/dockerfile-ast/issues/4))
- `PropertyInstruction`
  - `getPropertyArguments()` ([#37](https://github.com/rcjsuen/dockerfile-ast/issues/37))
- `Variable`
  - `getModifier()` ([#27](https://github.com/rcjsuen/dockerfile-ast/issues/27))
  - `getModifierRange()` ([#33](https://github.com/rcjsuen/dockerfile-ast/issues/33))
  - `getSubstitutionParameter()` ([#27](https://github.com/rcjsuen/dockerfile-ast/issues/27))
  - `getSubstitutionRange()` ([#33](https://github.com/rcjsuen/dockerfile-ast/issues/33))
  - `toString()` ([#4](https://github.com/rcjsuen/dockerfile-ast/issues/4))

### Changed
- `PropertyInstruction`
  - `getArguments()` ([#34](https://github.com/rcjsuen/dockerfile-ast/issues/34))
    - to make this function more predictable, `PropertyInstruction` no longer overrides this function with its own implementation, existing callers should call `getPropertyArguments()` instead if the old behaviour is desired
```TypeScript
// this function has been changed to possibly not return the same thing
// depending on the structure of the instruction's arguments
let args = propertyInstruction.getArguments();
// to get the same behaviour in 0.0.6, use getPropertyArguments() instead
let args = propertyInstruction.getPropertyArguments();
```

### Fixed
- resolve references to uninitialized `ARG` variables against `ARG` variables before the first `FROM` if present ([#26](https://github.com/rcjsuen/dockerfile-ast/issues/26))
- change `FROM` to parse its image argument correctly if it is in a private registry ([#28](https://github.com/rcjsuen/dockerfile-ast/issues/28))
- fix parsing issue with quoted keys and values in `ARG`, `ENV`, and `LABEL` ([#30](https://github.com/rcjsuen/dockerfile-ast/issues/30))
- ignore equals signs that are found inside quotes ([#29](https://github.com/rcjsuen/dockerfile-ast/issues/29))
- prevent arguments from being split up if they span multiple lines via escaped newlines ([#34](https://github.com/rcjsuen/dockerfile-ast/issues/34))
- prevent variables from being split up if they span multiple lines via escaped newlines ([#35](https://github.com/rcjsuen/dockerfile-ast/issues/35))

## [0.0.6] - 2018-04-19
### Changed
- `Property`
  - `getRawValue()` has been renamed to `getUnescapedValue()` ([#25](https://github.com/rcjsuen/dockerfile-ast/issues/25))
    - the underlying implementation of the function has not changed so it should be easy for clients to migrate to the new API

### Fixed
- fix parsing of spaces embedded within a variable replacement in `ARG`, `ENV`, and `LABEL` instructions ([#24](https://github.com/rcjsuen/dockerfile-ast/issues/24))

## [0.0.5] - 2018-04-15
### Fixed
- fix resolution of `ARG` variables that are used in a `FROM` ([#22](https://github.com/rcjsuen/dockerfile-ast/issues/22))
- prevent error from being thrown if an invalid line number is specified by `Dockerfile`'s `getAvailableVariables(number)` function ([#23](https://github.com/rcjsuen/dockerfile-ast/issues/23))

## [0.0.4] - 2018-04-03
### Added
- `JSONArgument extends Argument` ([#20](https://github.com/rcjsuen/dockerfile-ast/issues/20))
  - `getJSONRange()`
  - `getJSONValue()`
- `Comment`
  - `toString()` ([#4](https://github.com/rcjsuen/dockerfile-ast/issues/4))

### Changed
- `JSONInstruction`
  - `getJSONStrings()` now returns `JSONArgument[]` instead of `Argument[]`
    - since `JSONArgument` extends `Argument`, any existing code should continue to work with no code changes required

## [0.0.3] - 2018-02-10
### Added
- `From`
  - `getImageNameRange()` ([#16](https://github.com/rcjsuen/dockerfile-ast/issues/16))
- `Instruction`
  - `toString()` ([#4](https://github.com/rcjsuen/dockerfile-ast/issues/4))

### Fixed
- calling `ImageTemplate`'s `getAvailableVariables(number)` with a Dockerfile should only return the variables that are declared in the build stage of the given line ([#15](https://github.com/rcjsuen/dockerfile-ast/issues/15))
- correct `From`'s `getImageName()` to return the right name for the image if it is pointing at a digest ([#17](https://github.com/rcjsuen/dockerfile-ast/issues/17))
- calling `ImageTemplate`'s `getAvailableVariables(number)` on a line with a `FROM` should return variables defined by the Dockerfile's initial `ARG` instructions (if any) ([#18](https://github.com/rcjsuen/dockerfile-ast/issues/18))

## [0.0.2] - 2018-01-20
### Added
- `Argument`
  - `toString()` ([#4](https://github.com/rcjsuen/dockerfile-ast/issues/4))
- `Variable`
  - `isBuildVariable()` ([#13](https://github.com/rcjsuen/dockerfile-ast/issues/13))
  - `isDefined()` ([#12](https://github.com/rcjsuen/dockerfile-ast/issues/12))
  - `isEnvironmentVariable()` ([#13](https://github.com/rcjsuen/dockerfile-ast/issues/13))

### Fixed
- restrict variable resolution to the containing build stage ([#14](https://github.com/rcjsuen/dockerfile-ast/issues/14))

### Removed
- `Argument`'s `getRawValue()` function has been removed ([#10](https://github.com/rcjsuen/dockerfile-ast/issues/10))
```TypeScript
// this convenience function has been removed
let rawValue = argument.getRawValue();
// to retrieve the identical value, use the following code instead
import { TextDocument } from 'vscode-languageserver-types';
let document = TextDocument.create(uri, languageId, version, buffer);
let range = argument.getRange();
let rawValue = buffer.substring(document.offsetAt(range.start), document.offsetAt(range.end));
```

## 0.0.1 - 2017-12-20
### Added
- Dockerfile parser
  - handles escape characters
  - preserves comments
  - provides variable lookup and resolution

[Unreleased]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.30...HEAD
[0.0.30]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.29...v0.0.30
[0.0.29]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.28...v0.0.29
[0.0.28]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.27...v0.0.28
[0.0.27]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.26...v0.0.27
[0.0.26]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.25...v0.0.26
[0.0.25]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.24...v0.0.25
[0.0.24]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.23...v0.0.24
[0.0.23]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.22...v0.0.23
[0.0.22]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.21...v0.0.22
[0.0.21]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.20...v0.0.21
[0.0.20]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.19...v0.0.20
[0.0.19]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.18...v0.0.19
[0.0.18]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.17...v0.0.18
[0.0.17]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.16...v0.0.17
[0.0.16]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.15...v0.0.16
[0.0.15]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.14...v0.0.15
[0.0.14]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.13...v0.0.14
[0.0.13]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.12...v0.0.13
[0.0.12]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.11...v0.0.12
[0.0.11]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.10...v0.0.11
[0.0.10]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.9...v0.0.10
[0.0.9]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.8...v0.0.9
[0.0.8]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.7...v0.0.8
[0.0.7]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.6...v0.0.7
[0.0.6]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.5...v0.0.6
[0.0.5]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.4...v0.0.5
[0.0.4]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.3...v0.0.4
[0.0.3]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.2...v0.0.3
[0.0.2]: https://github.com/rcjsuen/dockerfile-ast/compare/v0.0.1...v0.0.2
