"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _html = _interopRequireDefault(require("../utils/html"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toBeCheckedAssertion
 * 
 */
function toBeChecked(enzymeWrapper) {
  let pass = false;
  const props = enzymeWrapper.props(); // Use `defaultChecked` if present.

  if (props.hasOwnProperty('defaultChecked') && typeof props.defaultChecked === 'boolean') {
    pass = props.defaultChecked;
  } // Use `checked` if present, will take precedence over `defaultChecked`.


  if (props.hasOwnProperty('checked') && typeof props.checked === 'boolean') {
    pass = props.checked;
  }

  return {
    pass,
    message: `Expected "${(0, _name.default)(enzymeWrapper)}" to be checked but it wasn't.`,
    negatedMessage: `Expected "${(0, _name.default)(enzymeWrapper)}" not to be checked but it was.`,
    contextualInformation: {
      actual: `Node HTML output: ${(0, _html.default)(enzymeWrapper)}`
    }
  };
}

var _default = (0, _single.default)(toBeChecked);

exports.default = _default;
module.exports = exports.default;