"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _html = _interopRequireDefault(require("../utils/html"));

var _name = _interopRequireDefault(require("../utils/name"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toBeDisabledAssertion
 * 
 */
function toBeDisabled(enzymeWrapper) {
  const pass = !!enzymeWrapper.prop('disabled');
  return {
    pass,
    message: `Expected node (${(0, _name.default)(enzymeWrapper)}) to be "disabled" but it wasn't.`,
    negatedMessage: `Expected node (${(0, _name.default)(enzymeWrapper)}) not to be "disabled" but it was`,
    contextualInformation: {
      expected: `Node HTML output: ${(0, _html.default)(enzymeWrapper)}`
    }
  };
}

var _default = (0, _single.default)(toBeDisabled);

exports.default = _default;
module.exports = exports.default;