"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _html = _interopRequireDefault(require("../utils/html"));

var _displayName = _interopRequireDefault(require("../utils/displayName"));

var _name = _interopRequireDefault(require("../utils/name"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toContainMatchingElement
 * 
 */
function toContainMatchingElement(enzymeWrapper, selector) {
  const matches = enzymeWrapper.find(selector);
  const pass = matches.length > 0;
  const nodeName = (0, _name.default)(enzymeWrapper);
  return {
    pass,
    message: `Expected <${nodeName}> to contain at least one element matching ` + `"${(0, _displayName.default)(selector)}" but none were found.`,
    negatedMessage: `Expected <${nodeName}> to not contain an element matching ` + `"${(0, _displayName.default)(selector)}" but it did.`,
    contextualInformation: {
      actual: `HTML Output of <${nodeName}>:\n ${(0, _html.default)(enzymeWrapper)}`
    }
  };
}

var _default = toContainMatchingElement;
exports.default = _default;
module.exports = exports.default;