"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _enzyme = require("enzyme");

var _html = _interopRequireDefault(require("../utils/html"));

var _name = _interopRequireDefault(require("../utils/name"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toContainReactAssertion
 * 
 */
function toContainReact(enzymeWrapper, reactInstance) {
  const wrappedInstance = (0, _enzyme.shallow)(reactInstance);
  const pass = enzymeWrapper.contains(reactInstance);
  return {
    pass,
    message: `Expected <${(0, _name.default)(enzymeWrapper)}> to contain ${(0, _html.default)(wrappedInstance)} but it was not found.`,
    negatedMessage: `Expected <${(0, _name.default)(enzymeWrapper)}> not to contain ${(0, _html.default)(wrappedInstance)} but it does.`,
    contextualInformation: {
      actual: `HTML Output of <${(0, _name.default)(enzymeWrapper)}>:\n ${(0, _html.default)(enzymeWrapper)}`
    }
  };
}

var _default = (0, _single.default)(toContainReact);

exports.default = _default;
module.exports = exports.default;