"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _name = _interopRequireDefault(require("../utils/name"));

var _html = _interopRequireDefault(require("../utils/html"));

var _single = _interopRequireDefault(require("../utils/single"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * This source code is licensed under the MIT-style license found in the
 * LICENSE file in the root directory of this source tree. *
 *
 * @providesModule toHaveTagNameAssertion
 * 
 */
function toHaveDisplayName(enzymeWrapper, tag) {
  const wrapperHtml = (0, _html.default)(enzymeWrapper);
  const actualTag = enzymeWrapper.name();
  const pass = actualTag === tag;
  const wrapperName = `<${(0, _name.default)(enzymeWrapper)}>`;
  return {
    pass,
    message: `Expected ${wrapperName} to have display name "${tag}" but it had display name "${actualTag}".`,
    negatedMessage: `Expected ${wrapperName} to not have display name "${tag}" but it did.`,
    contextualInformation: {
      actual: wrapperHtml
    }
  };
}

var _default = (0, _single.default)(toHaveDisplayName);

exports.default = _default;
module.exports = exports.default;